//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef MONTHTABLE_INCLUDE
#define MONTHTABLE_INCLUDE

#include <qtablevw.h>
#include <qpen.h>

class
MonthTable : public QTableView
{
	private:
	 Q_OBJECT
	 QString* contents;
	 int curRow;
	 int curCol;
	 int daysOfMonth;
	 int startOfWeek;
	 int curDay;
	 bool mustFit;

	public:
	 MonthTable(bool fit=false, QWidget* parent=0, const char* name=0);
	 ~MonthTable();
	 void resize(int,int);
    	 const char* getDayEvents(int) const;
	 void setDayEvent(int,const char*, bool event=false);
	 void clearMonth();
	 void setFit(bool f=false);

	protected:
	 void paintCell(QPainter*,int,int);
	 void mousePressEvent(QMouseEvent*);
	 void keyPressEvent(QKeyEvent*);
	 void focusInEvent(QFocusEvent*);
	 void focusOutEvent(QFocusEvent*);

	protected:
	signals:
	 void dayChanged(int);
	 void dayPicked(int);

	public slots:
	 void setDays(int,int);
	 void setCurrentDay(int);
	 void refreshDay(int);
};

#endif

