//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>
#include <klocale.h>

#include "Repeat.h"
#include "Day.h"

//
// create a blank Repeat item
//
Repeat::Repeat(Day* d)
{
	day = d;
	event = (DayEvent*)0;
	appoint = (Appointment*)0;
	interval = 0;
	clearEndDate();
}

//
// create a Repeat item based upon a day event
//
Repeat::Repeat(Day* d,DayEvent* e)
{
	day = d;
	event = e;
	appoint = (Appointment*)0;
	interval = 0;
	clearEndDate();
}

//
// create a Repeat item based upon an appointment
//
Repeat::Repeat(Day* d, Appointment* a)
{
	day = d;
	appoint = a;
	event = (DayEvent*)0;
	interval = 0;
	clearEndDate();
}

//
// tidy up
//
Repeat::~Repeat()
{
}

Day*
Repeat::getDay()
{
	return day;
}

DayEvent*
Repeat::getDayEvent()
{
	return event;
}

Appointment*
Repeat::getAppointment()
{
	return appoint;
}

//
// save this item to a file
//
void
Repeat::save(QDataStream& fil, bool hasChanged)
{
	if(hasChanged)
	{
		fil << EndDate;
		fil << interval;
	}
}

//
// load this item from a file
//
void
Repeat::load(QDataStream& fil, int /*version*/)
{
	fil >> EndDate;
	fil >> interval;
}

bool
Repeat::isAppointment()
{
	return (appoint != (Appointment*)0) ? true : false;
}

bool
Repeat::isDayEvent()
{
	return (event != (DayEvent*)0) ? true : false;
}

void
Repeat::setInterval(int i)
{
	interval = i;
}

int
Repeat::getInterval()
{
	return interval;
}

void
Repeat::clearEndDate()
{
	EndDate.setYMD(1900,1,1);
}

void
Repeat::setEndDate(QDate& d)
{
	EndDate = d;
}

void
Repeat::setEndDate(int y , int m, int d)
{
	EndDate.setYMD(y,m,d);
}

QDate&
Repeat::getEndDate()
{
	return EndDate;
}

int
Repeat::getYear()
{
	return (EndDate.isNull() || EndDate.year() == 1900) ? 0 : EndDate.year();
}

int
Repeat::getMonth()
{
	return (EndDate.isNull() || EndDate.year() == 1900) ? 0 : EndDate.month();
}

bool
Repeat::isForever()
{
	return (EndDate.isNull() || EndDate.year() == 1900) ? true : false;
}

//
// test a repeating item to see if it matches a selected date
//
bool
Repeat::testDate(QDate& cmpDate)
{
int y,m,d,nd,bd;
bool leap = false;

	if((!isForever()) && (EndDate < cmpDate))
	{
		return false;
	}
	QDate currDate = day->getDate();
	bd = currDate.daysInMonth();

	if((QDate::leapYear(currDate.year())) && (currDate.month() == 2) && ( currDate.day() == 29))
	{
		leap = true;
	}

	for(;currDate <= cmpDate;)
	{
		if(currDate == cmpDate)
		{
			return true;
		}
		y = currDate.year();
		m = currDate.month();
		d = currDate.day();
		nd = currDate.daysInMonth();
		if(interval == yearly)
		{
			y++;
			if((leap) && (!QDate::leapYear(y)))
			{
				d = 28;
			}
		}
		if(interval == month_by_day)
		{
			m++;
			if(m == 13)
			{
				m = 1;
				y++;
			}
			QDate tempDate(y,m,1);
			if(tempDate.daysInMonth() < bd)
			{
				d = tempDate.daysInMonth();
			}
		}
		if(interval == month_by_date)
		{
			int dow = currDate.dayOfWeek();	// day of the week
//+
//	Nick Thompson <uknt@micro.lucent.com>
//
//			int wom = (dow / 7) + 1;	// week of the month
			int wom = (currDate.day() - 1) / 7;
//-
			m++;
			if(m == 13)
			{
				m = 1;
				y++;
			}
			QDate tempDate(y,m,1);
			int wc = 0;
			for(;;)
			{
				if(tempDate.dayOfWeek() == dow)
				{
					wc++;
				}
				if(wc > wom)
				{
					break;
				}
				tempDate = tempDate.addDays(1);
			}
			y = tempDate.year();
			m = tempDate.month();
			d = tempDate.day();
		}
		if(interval == weekly)
		{
			QDate tempDate = currDate.addDays(7);
			y = tempDate.year();
			m = tempDate.month();
			d = tempDate.day();
		}
		if(interval == fortnightly)
		{
			QDate tempDate = currDate.addDays(7);
			y = tempDate.year();
			m = tempDate.month();
			d = tempDate.day();
		}
		currDate.setYMD(y,m,d);
	}
	return false;
}
