//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef REPEAT_INCLUDE
#define REPEAT_INCLUDE
//
//	The Repeat class contains details of each repeating item
//

#include <qdatetm.h>

class Appointment;
class DayEvent;
class Day;

class
Repeat
{
	public:
	 enum {yearly,month_by_day,month_by_date,weekly,fortnightly};

	private:
	 Day* day;
	 DayEvent* event;
	 Appointment* appoint;
	 QDate EndDate;
	 int interval;

	public:
	 Repeat(Day*);
	 Repeat(Day*,DayEvent*);
	 Repeat(Day*,Appointment*);
	 ~Repeat();
	 Day* getDay();
	 DayEvent* getDayEvent();
	 Appointment* getAppointment();
	 bool isAppointment();
	 bool isDayEvent();
	 void setInterval(int);
	 int getInterval();
	 void setEndDate(QDate&);
	 void clearEndDate();
	 void setEndDate(int,int,int d=1);
	 QDate& getEndDate();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int);
	 int getYear();
	 int getMonth();
	 bool isForever();
	 bool testDate(QDate&);
};

#endif
