//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qpainter.h>
#include <qkeycode.h>
#include <qprinter.h>
#include <kapp.h>
#include <kiconloader.h>

#include "TabularList.h"

//
// Create a tabular list
//
TabularList::TabularList(QWidget *parent, const char *name, int cols)
	: KTabListBox(parent,name,cols)
{
	KIconLoader* loader = kapp->getIconLoader();
	static QPixmap pixAlarm,pixFired,pixAlarmRep;
	static QPixmap pixTick,pixCross;
	static QPixmap pixBus,pixPer,pixAca;
	static QPixmap pixRepeat;
	static bool pixLoaded = false;

	clearTableFlags(Tbl_autoHScrollBar);

	if(!pixLoaded)
	{
		pixLoaded = true;

		pixAlarm = loader->loadIcon("alarm.xpm");
		pixFired = loader->loadIcon("fired.xpm");
		pixAlarmRep = loader->loadIcon("alarmrep.xpm");

		pixTick = loader->loadIcon("tick.xpm");
		pixCross = loader->loadIcon("cross.xpm");

		pixBus = loader->loadIcon("business.xpm");
		pixPer = loader->loadIcon("personal.xpm");
		pixAca = loader->loadIcon("academic.xpm");

		pixRepeat = loader->loadIcon("repeat.xpm");
	}

	dict().insert("A",&pixAlarm);
	dict().insert("a",&pixFired);
	dict().insert("r",&pixAlarmRep);
	dict().insert("Y",&pixTick);
	dict().insert("N",&pixCross);
	dict().insert("B",&pixBus);
	dict().insert("P",&pixPer);
	dict().insert("S",&pixAca);
	dict().insert("R",&pixRepeat);
}

void
TabularList::highlightItem(int)
{
}

int
TabularList::currentItem()
{
int i = KTabListBox::currentItem();

	return (isMarked(i)) ? i : -1;
}

