//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "TaskList.h"

#include "Ktodo.h"

//
// create a blank list of todo items
//
TaskList::TaskList()
{
	tasks.setAutoDelete(true);
}

//
// remove all todo items from the list
//
TaskList::~TaskList()
{
	remove();
}

//
// save all todo items to a file
//
void
TaskList::save(QDataStream& fil, bool hasChanged)
{
	ToDo *curr;
	QListIterator<ToDo> it(tasks);
	int recs = it.count();
	if(hasChanged)
	{
		fil << recs;
	}
	for(; it.current(); ++it)
	{
		curr = it.current();
		curr->save(fil,hasChanged);
	}
}

//
// load all todo items from a file and add to this list
//
void
TaskList::load(QDataStream& fil, int version)
{
ToDo *read;
int recs;

	fil >> recs;
	for( int i = 0; i < recs; i++)
	{
		read = new ToDo();
		read->load(fil,version);
		if(!read->isComplete())
		{
			tasks.append(read);
		}
	}
}

//
// remove all todo items from this list
//
void
TaskList::remove()
{
	tasks.clear();
}

//
// cycle through this list and display all todo items
//
void
TaskList::viewTasks(Ktodo* v)
{
	v->clear();
	ToDo *curr;
	QListIterator<ToDo> it(tasks);
	for(; it.current(); ++it)
	{
		curr = it.current();
		v->showTask(curr);
	}
}

//
// search for a todo item
//
ToDo*
TaskList::findTask(int ind)
{
	ToDo *curr;
	QListIterator<ToDo> it(tasks);
	for(int i = 0; it.current(); ++it, i++)
	{
		curr = it.current();
		if(i == ind)
		{
			return curr;
		}
	}
	return (ToDo*)0;
}

//
// add a new todo item to this list
//
ToDo*
TaskList::addTask(QDate& sd)
{
	ToDo* curr = new ToDo(sd);
	tasks.append(curr);
	return curr;
}

//
// remove a single todo item from this list
//
void
TaskList::removeTask(ToDo* a)
{
	tasks.remove(a);
}

