//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef TASKLIST_INCLUDE
#define TASKLIST_INCLUDE
//
//	The TaskList class contains a list of outstanding tasks
//
#include <qlist.h>

class Ktodo;
class ToDo;

#include "ToDo.h"

class
TaskList
{
	private:
	 QList<ToDo> tasks;	// linked list of outstanding tasks

	public:
	 TaskList();
	 ~TaskList();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int);
	 void remove();
	 void viewTasks(Ktodo*);
	 ToDo* findTask(int);
	 void removeTask(ToDo*);
	 ToDo* addTask(QDate&);
};

#endif
