//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>
#include <klocale.h>

#include "ToDo.h"

//
// create a blank todo item
//
ToDo::ToDo()
{
	subject = new QString("");
	text = new QString("");
	priority = 0;
	valid = false;
	complete = false;
	startDate = QDate::currentDate();
	duration = 0;
}

ToDo::ToDo(QDate& sd)
{
	subject = new QString("");
	text = new QString("");
	priority = 0;
	valid = false;
	complete = false;
	setStartDate(sd);
	duration = 0;
}

//
// create a todo item
//
ToDo::ToDo(QString& sub, int pri , QDate& sd, int dur, QString& txt=0)
{
	subject = new QString(sub);
	text = new QString(txt);
	setPriority(pri);
	setText(txt);
	setStartDate(sd);
	setDuration(dur);
	valid = false;
}

//
// tidy up
//
ToDo::~ToDo()
{
	delete subject;
	delete text;
}

//
// set the subject text of this todo item
//
void
ToDo::setSubject( QString& sub )
{
	subject->resize(0);
	subject->append(sub);
}

//
// return a reference to the subject text
//
QString&
ToDo::getSubject()
{
	return *subject;
}

//
// set the descriptive text of this todo item
//
void
ToDo::setText( QString& app )
{
	text->resize(0);
	text->append(app);
}

//
// return a reference to the descriptive text of this todo item
//
QString&
ToDo::getText()
{
	return *text;
}

//
// set the current priority of this todo item (0-2, high,med,low)
//
void
ToDo::setPriority(int p)
{
	priority = p;
}
//
// return the current priority of this todo item
//
int
ToDo::getPriority()
{
	return priority;
}

//
// set the current sensitivity of this todo item
//
void
ToDo::setSensitivity(int p)
{
	sensitivity = p;
}
//
// return the current priority of this todo item
//
int
ToDo::getSensitivity()
{
	return sensitivity;
}

//
// save this item to a file
//
void
ToDo::save(QDataStream& fil, bool hasChanged)
{
int len;
char *add;

	if(hasChanged)
	{
		fil << priority;
		len = subject->length();
		add = subject->data();
		fil << len;
		if(len)
		{
			fil.writeRawBytes(add,len);
		}
		len = text->length();
		add = text->data();
		fil << len;
		if(len)
		{
			fil.writeRawBytes(add,len);
		}
		fil << (int)complete;
		fil << startDate;
		fil << duration;
		fil << sensitivity;
	}
}

//
// load this item from a file
//
void
ToDo::load(QDataStream& fil, int version)
{
int len,comp;

	fil >> priority;
	fil >> len;
	subject->resize(len);
	if(len)
	{
		fil.readRawBytes(subject->data(),len);
	}
	subject->truncate(len);
	fil >> len;
	text->resize(len);
	if(len)
	{
		fil.readRawBytes(text->data(),len);
	}
	text->truncate(len);
	fil >> comp; complete = (bool)comp;
	if(version > 3)
	{
		fil >> startDate;
		fil >> duration;
	}
	if(version > 4)
	{
		fil >> sensitivity;
	}
	makeValid();
}

//
// return the status of this item.
// the EditTask class requires an existing instance of a ToDo class.
// if EditTask was creating a new ToDo item and quits, then this instance
// of the ToDo item is not required and should be deleted
//
bool
ToDo::isNew()
{
	return !valid;
}

//
// mark this todo item as valid (ie. EditTask exited rather than quit)
//
void
ToDo::makeValid()
{
	valid = true;
}

//
// mark this todo item as done
//
void
ToDo::makeComplete()
{
	complete = true;
}

//
// mark this todo item as not done
//
void
ToDo::makeInComplete()
{
	complete = false;
}

//
// return the status of this todo item (true - it is complete)
//
bool
ToDo::isComplete()
{
	return complete;
}


void
ToDo::setStartDate(QDate& d)
{
	startDate = d;
}


QDate&
ToDo::getStartDate()
{
	return startDate;
}


void
ToDo::setDuration(int d)
{
	duration = d;
}


int
ToDo::getDuration()
{
	return duration;
}

