//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef TODO_INCLUDE
#define TODO_INCLUDE
//
//	The ToDo class contains details of each todo item
//
#include <qstring.h>
#include <qfile.h>
#include <qlist.h>
#include <qdstream.h>
#include <qdatetm.h>

class
ToDo
{
	public:
	 enum {business,personal,academic};
	 enum {high,medium,low};

	private:
	 QString* subject;	// Subject text
	 QString* text;		// Descriptive text
	 int priority;		// priority of the item (hi,med,lo)
	 bool valid;		// item is valid
	 bool complete;		// item has been completed
	 QDate startDate;	// task start date
	 int duration;		// Length of task
	 int sensitivity;	// sensitivity of task

	public:
	 ToDo();
	 ToDo(QDate&);
	 ToDo(QString&,int,QDate&,int,QString& txt);
	 ~ToDo();
	 void setSubject(QString&);
	 QString& getSubject();
	 void setText(QString&);
	 QString& getText();
	 void setPriority(int);
	 int getPriority();
	 void setStartDate(QDate&);
	 QDate& getStartDate();
	 void setDuration(int);
	 int getDuration();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int);
	 bool isNew();
	 void makeValid();
	 void makeComplete();
	 void makeInComplete();
	 bool isComplete();
	 void setSensitivity(int);
	 int getSensitivity();
};

#endif
