//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UserAccess.h"

//
// create a user access item
//
UserAccess::UserAccess()
{
	username = new QString(" ");
	add_public = false;
	del_public = false;
	view_business = false;
	add_business = false;
	del_business = false;
	view_personnal = false;
	add_personnal = false;
	del_personnal = false;
}

UserAccess::UserAccess(QString& user, bool a, bool b, bool c, bool d, bool e, bool f, bool g, bool h)
{
	username = new QString(user);
	add_public = a;
	del_public = b;
	view_business = c;
	add_business = d;
	del_business = e;
	view_personnal = f;
	add_personnal = g;
	del_personnal = h;
}

//
// tidy up
//
UserAccess::~UserAccess()
{
	delete username;
}

//
// set the subject text of this UserAccess item
//
void
UserAccess::setUsername( QString& user )
{
	username->resize(0);
	username->append(user);
}

//
// save this item to a file
//
void
UserAccess::save(QDataStream& fil, bool hasChanged)
{
int len;
char *add;

	if(hasChanged)
	{
		len = username->length();
		add = username->data();
		fil << len;
		if(len)
		{
			fil.writeRawBytes(add,len);
		}
		fil << (int)add_public;
		fil << (int)del_public;
		fil << (int)view_business;
		fil << (int)add_business;
		fil << (int)del_business;
		fil << (int)view_personnal;
		fil << (int)add_personnal;
		fil << (int)del_personnal;
	}
}

//
// load this item from a file
//
void
UserAccess::load(QDataStream& fil, int version)
{
int len,c;

	fil >> len;
	username->resize(len);
	if(len)
	{
		fil.readRawBytes(username->data(),len);
	}
	username->truncate(len);

	fil >> c; add_public = (bool)c;
	fil >> c; del_public = (bool)c;
	fil >> c; view_business = (bool)c;
	fil >> c; add_business = (bool)c;
	fil >> c; del_business = (bool)c;
	fil >> c; view_personnal = (bool)c;
	fil >> c; add_personnal = (bool)c;
	fil >> c; del_personnal = (bool)c;
}

//
// set the public access bits
//
void
UserAccess::setPublic(bool a, bool d)
{
	add_public = a;
	del_public = d;
}

//
// set the business access bits
//
void
UserAccess::setBusiness(bool v, bool a, bool d)
{
	view_business = v;
	add_business = a;
	del_business = d;
}

//
// set the personnal access bits
//
void
UserAccess::setPersonnal(bool v, bool a, bool d)
{
	view_personnal = v;
	add_personnal = a;
	del_personnal = d;
}

QString&
UserAccess::getUsername()
{
	return *username;
}


bool
UserAccess::canAddPublic()
{
	return add_public;
}

bool
UserAccess::canDelPublic()
{
	return del_public;
}

bool
UserAccess::canViewBusiness()
{
	return view_business;
}

bool
UserAccess::canAddBusiness()
{
	return add_business;
}

bool
UserAccess::canDelBusiness()
{
	return del_business;
}

bool
UserAccess::canViewPersonnal()
{
	return view_personnal;
}

bool
UserAccess::canAddPersonnal()
{
	return add_personnal;
}

bool
UserAccess::canDelPersonnal()
{
	return del_personnal;
}

bool
UserAccess::canAdd()
{
	return add_public | add_business | add_personnal;
}

bool
UserAccess::canDelete()
{
	return del_public | del_business | del_personnal;
}

