//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef USERACCESS_INCLUDE
#define USERACCESS_INCLUDE
//
//	The UserAccess class defines the access a user has to a calendar
//
#include <qstring.h>
#include <qfile.h>
#include <qlist.h>
#include <qdstream.h>

class
UserAccess
{
	private:
	 QString* username;	// name of user
	 bool add_public;
	 bool del_public;
	 bool view_business;
	 bool add_business;
	 bool del_business;
	 bool view_personnal;
	 bool add_personnal;
	 bool del_personnal;

	public:
	 UserAccess();
	 UserAccess(QString&, bool a=false, bool b=false, bool c=false, bool d=false, bool e=false, bool f=false, bool g=false, bool h=false);
	 ~UserAccess();
	 void setUsername(QString&);
	 QString& getUsername();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int);
	 void setPublic(bool,bool);
	 void setBusiness(bool,bool,bool);
	 void setPersonnal(bool,bool,bool);
	 bool canAddPublic();
	 bool canDelPublic();
	 bool canViewBusiness();
	 bool canAddBusiness();
	 bool canDelBusiness();
	 bool canViewPersonnal();
	 bool canAddPersonnal();
	 bool canDelPersonnal();
	 bool canAdd();
	 bool canDelete();
};

#endif
