//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UserList.h"

//
// create a blank list of user access items
//
UserList::UserList()
{
	users.setAutoDelete(true);
}

//
// remove all user access items from the list
//
UserList::~UserList()
{
	remove();
}

//
// save all user access items to a file
//
void
UserList::save(QDataStream& fil, bool hasChanged)
{
	UserAccess *curr;
	QListIterator<UserAccess> it(users);
	int recs = it.count();
	if(hasChanged)
	{
		fil << recs;
	}
	for(; it.current(); ++it)
	{
		curr = it.current();
		curr->save(fil,hasChanged);
	}
}

//
// load all user access items from a file and add to this list
//
void
UserList::load(QDataStream& fil, int version)
{
UserAccess *read;
int recs;

	fil >> recs;
	for( int i = 0; i < recs; i++)
	{
		read = new UserAccess();
		read->load(fil,version);
		users.append(read);
	}
}

//
// remove all user access items from this list
//
void
UserList::remove()
{
	users.clear();
}

//
// search for a user access item
//
UserAccess*
UserList::findUser(QString& who)
{
	UserAccess *curr;
	QListIterator<UserAccess> it(users);
	for(int i = 0; it.current(); ++it, i++)
	{
		curr = it.current();
		if(who == curr->getUsername())
		{
			return curr;
		}
	}
	return (UserAccess*)0;
}

//
// add a new user access item to this list
//
UserAccess*
UserList::addUser(QString& user)
{
	UserAccess* curr = new UserAccess(user);
	users.append(curr);
	return curr;
}

//
// remove a single user access item from this list
//
void
UserList::removeUser(UserAccess* u)
{
	users.remove(u);
	delete u;
}

//
// populate a listbox with users
//
void
UserList::listUsers(QListBox& l)
{
	UserAccess *curr;
	QListIterator<UserAccess> it(users);
	for(int i = 0; it.current(); ++it, i++)
	{
		curr = it.current();
		l.insertItem(curr->getUsername());
	}
}
