//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef USERLIST_INCLUDE
#define USERLIST_INCLUDE
//
//	The UserList class contains a list of users who can access this calendar
//
#include <qlist.h>
#include <qlistbox.h>

class UserAccess;

#include "UserAccess.h"

class
UserList
{
	private:
	 QList<UserAccess> users;	// linked list of users

	public:
	 UserList();
	 ~UserList();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int);
	 void remove();
	 UserAccess* findUser(QString&);
	 void removeUser(UserAccess*);
	 UserAccess* addUser(QString&);
	 void listUsers(QListBox&);

};

#endif
