//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>
#include <klocale.h>

#include "ViewAppointment.h"

#include "Calendar.h"
#include "Appointment.h"
#include "TimeSlots.h"

ViewAppointment::ViewAppointment(Appointment* a, Calendar* c, QWidget* parent, const char* name)
	: QDialog(parent,name)
{
	event = a;
	cal = c;
	baseDate = cal->getDate();

	l1 = new QLabel(this);
	l1->setGeometry( 0, 0, 70, 20 );
	l1->setText(klocale->translate("Subject :"));
	l1->setAlignment( 290 );

	l2 = new QLabel(this);
	l2->setGeometry( 0, 35, 70, 20 );
	l2->setText(klocale->translate("Start Time :"));
	l2->setAlignment( 290 );

	l3 = new QLabel(this);
	l3->setGeometry( 0, 65, 72, 20 );
	l3->setText(klocale->translate("Finish Time :"));
	l3->setAlignment( 290 );

	l4 = new QLabel(this);
	l4->setGeometry( 0, 95, 70, 20 );
	l4->setText(klocale->translate("Sensitivity :"));
	l4->setAlignment( 290 );

	Subject = new QMultiLineEdit(this);
	Subject->setGeometry( 80, 0, 240, 22 );
	Subject->setText( event->getSubject() );

	StartDate = new QComboBox(false,this);
	StartDate->setGeometry( 80, 30, 140, 30 );

	StartTime = new QComboBox(false,this);
	StartTime->setGeometry( 230, 30, 70, 30 );

	FinishDate = new QComboBox(false,this);
	FinishDate->setGeometry( 80, 60, 140, 30 );

	FinishTime = new QComboBox(false,this);
	FinishTime->setGeometry( 230, 60, 70, 30 );

	Sensitivity = new QComboBox(false,this);
	Sensitivity->setGeometry( 80, 90, 120, 30 );

	AppointmentText = new QMultiLineEdit(this);
	AppointmentText->setGeometry( 80, 130, 240, 60 );
	AppointmentText->setText( event->getText() );

	okay = new QPushButton(klocale->translate("Okay"),this);
	okay->resize(40,30);
	okay->setGeometry(240,240,60,30);
	okay->setDefault(true);

	repeat = new QPushButton(klocale->translate("Repeat"),this);
	repeat->resize(40,30);
	repeat->setGeometry(170,240,60,30);
	repeat->setDefault(true);

	populateTime(StartTime);
	populateTime(FinishTime);
	populateDate(StartDate,baseDate);
	populateDate(FinishDate,baseDate);
	populateSensitivity(Sensitivity);

	StartTime->setCurrentItem(event->getStartTime());
	FinishTime->setCurrentItem(event->getFinishTime() + 1);
	Sensitivity->setCurrentItem(event->getSensitivity());

	resize(300,300);

	connect(okay,SIGNAL(clicked()),SLOT(exit()));

	disable();

	Subject->setFocus();
}

ViewAppointment::~ViewAppointment()
{
	delete l1;
	delete l2;
	delete l3;
	delete l4;
	delete Subject;
	delete StartDate;
	delete StartTime;
	delete FinishDate;
	delete FinishTime;
	delete Sensitivity;
	delete AppointmentText;
	delete okay;
	delete repeat;
}

void
ViewAppointment::exit()
{
	emit exitAppointment();
}

void
ViewAppointment::populateTime(QComboBox* cb)
{
TimeSlots ts;

	cb->setSizeLimit(10);
	for(int i = 0; i < TimeSlots::totalSlots; i++)
	{
		cb->insertItem(ts.whichTime(i));
	}
}

void
ViewAppointment::populateDate(QComboBox* cb, QDate start)
{
	for(int i = 0; i < 14; i++, start = start.addDays(1))
	{
		cb->insertItem(start.toString());

	}
}

void
ViewAppointment::disable()
{
	Subject->setReadOnly(true);
	AppointmentText->setReadOnly(true);
	StartTime->setEnabled(false);
	FinishTime->setEnabled(false);
	StartDate->setEnabled(false);
	FinishDate->setEnabled(false);
	Sensitivity->setEnabled(false);
}
//
// set the sensitivity text
//
void
ViewAppointment::populateSensitivity(QComboBox* cb)
{
	cb->setSizeLimit(3);
	cb->insertItem(klocale->translate("Public"));
	cb->insertItem(klocale->translate("Business"));
	cb->insertItem(klocale->translate("Personnal"));
}

