//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef VIEWAPPOINTMENT_INCLUDE
#define VIEWAPPOINTMENT_INCLUDE
//
//	The ViewAppointment class is used to View an Appointment details
//
#include <qwidget.h>
#include <qdialog.h>
#include <qcombo.h>
#include <qmlined.h>
#include <qpushbt.h>
#include <qchkbox.h>
#include <qdatetm.h>
#include <qlined.h>
#include <qlabel.h>
#include <qmsgbox.h>

class Calendar;
class Appointment;
class Repeat;
class EditRepeat;

class
ViewAppointment : public QDialog
{
	private:
	 Q_OBJECT
	protected:
	 QMultiLineEdit* Subject;
	 QComboBox* StartDate;
	 QComboBox* StartTime;
	 QComboBox* FinishDate;
	 QComboBox* FinishTime;
	 QComboBox* Sensitivity;
	 QMultiLineEdit* AppointmentText;
	 QPushButton* okay;
	 QPushButton* repeat;
	 QLabel* l1;
	 QLabel* l2;
	 QLabel* l3;
	 QLabel* l4;

	 Calendar* cal;
	 Appointment* event;
	 QDate baseDate;

	 EditRepeat* editRep;

	public:
	 ViewAppointment(Appointment*,Calendar*,QWidget* parent=0,const char* name=0);
	 ~ViewAppointment();

	protected:
	 void populateTime(QComboBox*);
	 void populateDate(QComboBox*,QDate);
	 void populateSensitivity(QComboBox*);
	 void disable();

	protected:
	signals:
	 void exitAppointment();

	public slots:
	 void exit();
};

#endif
