//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "ViewTask.h"

#include "ToDo.h"
#include "DateDuration.h"

#include <kapp.h>
#include <klocale.h>

//
// create a ToDo item viewer
//
ViewTask::ViewTask(ToDo* t, QWidget* parent, const char* name)
	: QDialog(parent,name)
{
	todo = t;

	l1 = new QLabel(this);
	l1->setGeometry( 0, 0, 70, 20 );
	l1->setText(klocale->translate("Subject :"));
	l1->setAlignment( 290 );

	l2 = new QLabel(this);
 	l2->setGeometry( 0, 35, 70, 20 );
	l2->setText(klocale->translate("Priority :"));
	l2->setAlignment( 290 );

	l3 = new QLabel(this);
	l3->setGeometry( 0, 65, 70, 20 );
	l3->setText(klocale->translate("Duration :"));
	l3->setAlignment( 290 );

	l4 = new QLabel(this);
	l4->setGeometry( 0, 115, 70, 20 );
	l4->setText(klocale->translate("Sensitivity :"));
	l4->setAlignment( 290 );

	Subject = new QMultiLineEdit(this);
	Subject->setGeometry( 80, 0, 240, 22 );
	Subject->setText( todo->getSubject() );

	Priority = new QComboBox(false,this);
	Priority->setGeometry( 80, 30, 140, 30 );
	Priority->setSizeLimit(3);
	Priority->insertItem(klocale->translate("High"));
	Priority->insertItem(klocale->translate("Normal"));
	Priority->insertItem(klocale->translate("Low"));
	Priority->setCurrentItem(todo->getPriority());

	StartDate = new DateDuration(90,this);
	StartDate->setGeometry(80,60,120,40);
	StartDate->setStartDate(todo->getStartDate());
	StartDate->setDuration(0);

	EndDate = new DateDuration(90,this);
	EndDate->setGeometry(230,60,120,40);
	EndDate->setStartDate(todo->getStartDate());
	EndDate->setDuration(todo->getDuration());

	TaskText = new QMultiLineEdit(this);
	TaskText->setGeometry( 80, 150, 240, 60 );
	TaskText->insertLine( todo->getText() );
	TaskText->setReadOnly(false);
	TaskText->setOverwriteMode(false);

	Sensitivity = new QComboBox(false,this);
	Sensitivity->setGeometry( 80, 110, 120, 30 );

	okay = new QPushButton(klocale->translate("Okay"),this);
	okay->resize(40,30);
	okay->setGeometry(240,240,60,30);
	okay->setDefault(true);

	resize(300,300);

	connect(okay,SIGNAL(clicked()),SLOT(exit()));

	disable();

	populateSensitivity(Sensitivity);

	Sensitivity->setCurrentItem(todo->getSensitivity());

	Subject->setFocus();
}

//
// tidy up
//
ViewTask::~ViewTask()
{
	delete l1;
	delete l2;
	delete l3;
	delete l4;
	delete Subject;
	delete Priority;
	delete TaskText;
	delete okay;
	delete StartDate;
	delete EndDate;
	delete Sensitivity;
}

//
// signal emitted when the okay button is presed
//
void
ViewTask::exit()
{
	emit exitTask();
}

//
// prevent entry/selection from any widgets
//
void
ViewTask::disable()
{
	Subject->setReadOnly(true);
	TaskText->setReadOnly(true);
	Priority->setEnabled(false);
	StartDate->setEnabled(false);
	EndDate->setEnabled(false);
	Sensitivity->setEnabled(false);
}

//
// set the sensitivity text
//
void
ViewTask::populateSensitivity(QComboBox* cb)
{
	cb->setSizeLimit(3);
	cb->insertItem(klocale->translate("Business"));
	cb->insertItem(klocale->translate("Personnal"));
	cb->insertItem(klocale->translate("Academic"));
}

