//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef VIEWTASK_INCLUDE
#define VIEWTASK_INCLUDE
//
//	The ViewTask class is used to View a tasks details
//
#include <qwidget.h>
#include <qdialog.h>
#include <qcombo.h>
#include <qmlined.h>
#include <qpushbt.h>
#include <qchkbox.h>
#include <qdatetm.h>
#include <qlined.h>
#include <qlabel.h>
#include <qmsgbox.h>

class ToDo;
class DateDuration;

class
ViewTask : public QDialog
{
	private:
	 Q_OBJECT

	protected:
	 QMultiLineEdit* Subject;
	 QComboBox* Priority;
	 QMultiLineEdit* TaskText;
	 QComboBox* Sensitivity;
	 DateDuration* StartDate;
	 QPushButton* okay;
	 QLabel* l1;
	 QLabel* l2;
	 QLabel* l3;
	 QLabel* l4;
	 DateDuration* EndDate;

	 ToDo* todo;

	public:
	 ViewTask(ToDo*,QWidget* parent=0,const char* name=0);
	 ~ViewTask();

	protected:
	 void disable();
	 void populateSensitivity(QComboBox*);

	protected:
	signals:
	 void exitTask();

	public slots:
	 void exit();
};

#endif
