//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef YEARTABLE_INCLUDE
#define YEARTABLE_INCLUDE

#include <qtablevw.h>
#include <qpen.h>

class
YearTable : public QTableView
{
	private:
	 Q_OBJECT
	 int curRow;
	 int curCol;
	 int curYear;
	 int events[13][42];
	 bool mustFit;

	public:
	 enum {appointment=1,daynote=2,dayevent=4,holiday=8};

	public:
	 YearTable(bool fit=false, QWidget* parent=0, const char* name=0);
	 ~YearTable();
	 void resize(int,int);
	 const char* getDayEvents(int) const;
	 void setDayEvent(int,int,int,bool,int,bool);
	 void clearYear();
	 void setYear(int);
	 void addToDay(int,int,int,int e=0, bool h=false);
	 void setFit(bool f=false);

	protected:
	 void paintCell(QPainter*,int,int);
	 void mousePressEvent(QMouseEvent*);

	private:
	 int monthOffset(int);

	protected:
	signals:
	 void dayChanged(int,int);
	 void dayPicked(int,int);

	public slots:
	 void setCurrentDay(int,int);
	 void refreshDay(int,int);
};

#endif

