//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>
#include <klocale.h>

#include "cfgDateFormat.h"

//
// create a groupbox with two buttons allowing selection date formats
//
cfgDateFormat::cfgDateFormat(QWidget *parent, const char *name) 
	: QButtonGroup(parent,name)
{
	setTitle(klocale->translate("Date Format"));
	setFrameStyle(QFrame::Raised | QFrame::Box);
	setGeometry(10,75,275,50);
	setExclusive(TRUE);
	
	dateDMY = new QRadioButton(this);
	dateDMY->setText(klocale->translate("dd/mm/yyyy"));
	dateDMY->setChecked(true);
	dateDMY->setGeometry(20,15,100,30);
	
	dateMDY = new QRadioButton(this);
	dateMDY->setText(klocale->translate("mm/dd/yyyy"));
	dateMDY->setChecked(false);
	dateMDY->setGeometry(150,20,100,20);
	
	insert(dateDMY,0);
	insert(dateMDY,1);
}

cfgDateFormat::~cfgDateFormat()
{
	delete dateDMY;
	delete dateMDY;
}

//
// select the radio button to check
//
void
cfgDateFormat::setDateFormat(int df)
{
	switch(df)
	{
	case 1 :
	 	dateDMY->setChecked(false);
	 	dateMDY->setChecked(true);	break;
	default:
	 	dateMDY->setChecked(false);
	 	dateDMY->setChecked(true);	break;
	}
}
