//
// (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>
#include <klocale.h>

#include "cfgStartWeek.h"

//
// create a groupbox with two buttons allowing selection date formats
//
cfgStartWeek::cfgStartWeek(QWidget *parent, const char *name) 
	: QButtonGroup(parent,name)
{
	setTitle(klocale->translate("Start of Week"));
	setFrameStyle(QFrame::Raised | QFrame::Box);
	setExclusive(TRUE);
	
	Sun = new QRadioButton(this);
	Sun->setText(klocale->translate("Sun"));
	Sun->setChecked(true);
	Sun->setGeometry(20,20,50,20);
	
	Mon = new QRadioButton(this);
	Mon->setText(klocale->translate("Mon"));
	Mon->setChecked(false);
	Mon->setGeometry(80,20,50,20);

	Tue = new QRadioButton(this);
	Tue->setText(klocale->translate("Tue"));
	Tue->setChecked(false);
	Tue->setGeometry(140,20,50,20);

	Wed = new QRadioButton(this);
	Wed->setText(klocale->translate("Wed"));
	Wed->setChecked(false);
	Wed->setGeometry(200,20,50,20);

	Thu = new QRadioButton(this);
	Thu->setText(klocale->translate("Thu"));
	Thu->setChecked(false);
	Thu->setGeometry(20,40,50,20);

	Fri = new QRadioButton(this);
	Fri->setText(klocale->translate("Fri"));
	Fri->setChecked(false);
	Fri->setGeometry(80,40,50,20);

	Sat = new QRadioButton(this);
	Sat->setText(klocale->translate("Sat"));
	Sat->setChecked(false);
	Sat->setGeometry(140,40,50,20);

	insert(Sun,0);
	insert(Mon,1);
	insert(Tue,2);
	insert(Wed,3);
	insert(Thu,4);
	insert(Fri,5);
	insert(Sat,6);

	Sun->setEnabled(false);
	Mon->setEnabled(false);
	Tue->setEnabled(false);
	Wed->setEnabled(false);
	Thu->setEnabled(false);
	Fri->setEnabled(false);
	Sat->setEnabled(false);

}

cfgStartWeek::~cfgStartWeek()
{
	delete Sun;
	delete Mon;
	delete Tue;
	delete Wed;
	delete Thu;
	delete Fri;
	delete Sat;
}

//
// select the radio button to check
//
void
cfgStartWeek::setStartWeek(int df)
{
	Sun->setChecked(false);
	Mon->setChecked(false);
	Tue->setChecked(false);
	Wed->setChecked(false);
	Thu->setChecked(false);
	Fri->setChecked(false);
	Sat->setChecked(false);

	switch(df)
	{
	case 0 : Sun->setChecked(true);	break;
	case 1 : Mon->setChecked(true);	break;
	case 2 : Tue->setChecked(true);	break;
	case 3 : Wed->setChecked(true);	break;
	case 4 : Thu->setChecked(true);	break;
	case 5 : Fri->setChecked(true);	break;
	case 6 : Sat->setChecked(true);	break;
	}
}
