//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qtooltip.h>
#include <qdir.h>
#include <kwm.h>
#include <kapp.h>

#include "docking.h"

#include "Alarm.h"
#include "Klook.h"

DockWidget::DockWidget(Klook* p, const char *name)
	: QWidget(0,name,0)
{
	docked = false;
	alarm = 0;
	parent = p;

	QString pixdir = KApplication::kde_datadir() + QString("/kalendar/pics/");

	dock_normal_pixmap.load(pixdir + "mini-kalendar.xpm");
	dock_alarm_pixmap.load(pixdir + "alarm.xpm");

	popup_m = new QPopupMenu();

}

DockWidget::~DockWidget()
{
	remove();
// don't call, it causes a core dump !!!
//	popup_m->clear();
//	delete popup_m;
}

void
DockWidget::dock()
{
	if(!docked)
	{
		KWM::setDockWindow(this->winId());
		this->setFixedSize(16,16);
		this->show();
		docked = true;
	}
}

void
DockWidget::undock()
{
	if(docked)
	{

// the widget's window has to be destroyed in order
// to undock from the panel. Simply using hide() is
// not enough (seems to be necessary though).

		this->hide();
		this->destroy(true,true);
		this->create(0,true,false);
		docked = false;
	}
}

const bool
DockWidget::isDocked()
{
	return docked;
}

void
DockWidget::setAlarm(Alarm* a)
{
	alarm++;
	list.append(a);
	repaint();
}

void
DockWidget::resetAlarm(Alarm* a)
{
	alarm--;
	list.remove(a);
	repaint();
}

void
DockWidget::paintEvent(QPaintEvent *)
{
	if(alarm != 0)
	{
		bitBlt(this,0,0,&dock_alarm_pixmap);
	}
	else
	{
		bitBlt(this,0,0,&dock_normal_pixmap);
	}
}


void
DockWidget::mousePressEvent(QMouseEvent *e)
{
	if(e->button() == LeftButton)
	{
//+
// Rudolf Heeb <RDH@software-ag.de>
//
		KConfig* config = KApplication::getKApplication()->getConfig();
		bool startDocked;
//-
		if(parent->isVisible())
		{
			parent->hide();
			startDocked = true;
		}
		else
		{
			parent->show();
			startDocked = false;
		}
//+
// Rudolf Heeb <RDH@software-ag.de>
//
		config->setGroup("Session");
		config->writeEntry(klocale->translate("StartDocked"),startDocked);
		config->sync();
//-
	}

	// create and process firing alarms menu
	if((alarm != 0) && (e->button() == RightButton))
	{
		popup_m->clear();
		popup_m = new QPopupMenu();
		Alarm *a;
		QListIterator<Alarm> it(list);
		for(; it.current(); ++it)
		{
			a = it.current();
			QString repeat(klocale->translate("Repeat "));
			repeat.append(a->getSubject());
			QString accept(klocale->translate("Cancel "));
			accept.append(a->getSubject());
			popup_m->insertItem(repeat.data(),a->getAlarmBox(),SLOT(repeatPressed()));
			popup_m->insertItem(accept.data(),a->getAlarmBox(),SLOT(okayPressed()));
		}
		popup_m->popup(QPoint(e->x() + this->x() , e->y() + this->y()));
		popup_m->exec();
	}
}

//
// remove all alarms from the dock
//
void
DockWidget::remove()
{
	list.clear();
}

