//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef DOCKING_INCLUDE
#define DOCKING_INCLUDE

#include <stdio.h>
#include <qapp.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qpopmenu.h>
#include <qpoint.h>
#include <qlist.h>

class Alarm;
class Klook;

#include "Alarm.h"

class DockWidget : public QWidget
{
	private:
	 Q_OBJECT

	private:
	 Klook* parent;
	 bool docked;
	 int alarm;
	 QList<Alarm> list;		// list of current alarms

	 QPopupMenu* popup_m;

	 QPixmap dock_normal_pixmap;
	 QPixmap dock_alarm_pixmap;

	private:
	 void remove();

	public:
	 DockWidget(Klook*, const char* name=0);
	 ~DockWidget();
	 const bool isDocked();
	 void setAlarm(Alarm*);
	 void resetAlarm(Alarm*);


	protected:
	 void paintEvent(QPaintEvent*);

	private slots:
	 void mousePressEvent(QMouseEvent*);

	public slots:
	 void dock();
	 void undock();

};

#endif
