#include "forms.h"
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h> 
#include "xmemos.h"
#include "xmemos2.h"

FD_xmemos *fd_xmemos;
struct page Pages[MAX_PAGES];
int g_autosave;
int g_curPage;

int fileStrInput(FILE *fichier, char *string, char chr);


void setColButton(int noPage)
{
  FL_OBJECT *bouton;

  switch(noPage)
    {
  case 0:
    bouton = fd_xmemos->un;
    break;
  case 1:
    bouton = fd_xmemos->deux;
    break;
  case 2:
    bouton = fd_xmemos->trois;
    break;
  case 3:
    bouton = fd_xmemos->quatre;
    break;
  case 4:
    bouton = fd_xmemos->cinq;
    break;
  case 5:
    bouton = fd_xmemos->six;
    break;
  case 6:
    bouton = fd_xmemos->sept;
    break;
  case 7:
    bouton = fd_xmemos->huit;
    break;
  case 8:
    bouton = fd_xmemos->neuf;
    break;
  case 9:
    bouton = fd_xmemos->dix;
    break;
  case 10:
    bouton = fd_xmemos->onze;
    break;
  case 11:
    bouton = fd_xmemos->douze;
    break;
  default:
    bouton = fd_xmemos->un;

    }
  
  if(Pages[noPage].flagMod)
    {
      fl_set_object_color(bouton, FL_YELLOW, FL_DARKCYAN);
    }
  else
    {
      if(Pages[noPage].data[0])
	{
          fl_set_object_color(bouton, FL_GREEN, FL_DARKCYAN);
	}
      else
	{
	  fl_set_object_color(bouton, FL_COL1, FL_DARKCYAN);
	}
    }
	  
  fl_redraw_object(bouton);
}

int mallocPage(int noPage)
{
  Pages[noPage].flagMod = 0;
  Pages[noPage].size = PAGES_MEM;
  Pages[noPage].data  = (char *) malloc(PAGES_MEM);
  if(Pages[noPage].data != NULL)
    return 1;
  return 0;
}

void reallocPage(int noPage, int newsize)
{
  newsize++;
  Pages[noPage].data = (char *) realloc((char *) Pages[noPage].data, (size_t) newsize);
  Pages[noPage].size = newsize;
}

void freePage(int noPage)
{
  free(Pages[noPage].data);
}

void clearPage(int noPage)
{
  Pages[noPage].data[0] = '\0';
  setColButton(noPage);
}

int savePage(int noPage)
{
  FILE *f1;
  char path[132];
  
  if(Pages[noPage].flagMod == 0) return 0;
  
  sprintf(path, "%s/.xmemos/xmemos.%02d", getenv("HOME"), noPage);
  f1 = fopen(path, "w");
  if(f1 == NULL)
    {
      fl_show_message("Can't write ", path, "");
      return 1;
    }
  
  fprintf(f1, "%s", Pages[noPage].data);
  fclose(f1);
  
  Pages[noPage].flagMod = 0;
  setColButton(noPage);
  return 0;
}



int fileStrInput(FILE *fichier, char *string, char chr)
									       /* fichier d'ou lire le string     */
									       /* pointe ou mettre le string lu   */
									       /* caractere de fin de string      */
{
  int i, c;

  i = 0;
  for(;;)
  {
    c = fgetc(fichier);
    if(c != EOF)
    {
      if(c == chr) break;
      string[i++] = (unsigned char) c;
    }
    else break;
  }
  string[i] = '\0';

  if(c == EOF && i == 0)  return(EOF); else return(i);
}

int readPage(int noPage)
{
  FILE *f1;
  char path[132];
  int c;
  char *str;

  sprintf(path, "%s/.xmemos/xmemos.%02d", getenv("HOME"), noPage);
  if(access(path, R_OK)) return 0;
  
  str = (char *) malloc(32000);
  if(!str) return 0;
  
  f1 = fopen(path, "r");
  if(f1 == NULL)
    {
      fl_show_message("Can't read ", path, "");
      return 1;
    }
  
  c = fileStrInput(f1, str, '\0');
  fclose(f1);

  if(c != EOF)
    {
      reallocPage(noPage, c);
      strcpy(Pages[noPage].data, str);
    }
  Pages[noPage].flagMod = 0;
  setColButton(noPage);

  free(str);
  return 0;
}

int printPage(int noPage)
{
  FILE *f1;
  inputToPage(noPage);
  
  f1 = popen(PRINTCMD, "w");
  if(f1 != NULL)
    {
      fprintf(f1, "%s", Pages[noPage].data);
      pclose(f1);
    }
  
  return 0;
}

void pageToInput(int noPage)
{
  fl_set_input(fd_xmemos->input, Pages[noPage].data);
}

void inputToPage(int noPage)
{
  int lg;
  lg = strlen(fl_get_input(fd_xmemos->input));
  reallocPage(noPage, lg);
  strcpy(Pages[noPage].data, fl_get_input(fd_xmemos->input));
}

int main(int argc, char *argv[])
{
  int i;

/*   fl_initialize(&argc, argv, 0, 0, 0); */
  fl_initialize(&argc, argv, "xmemos", 0,0);
  fd_xmemos = create_form_xmemos();

   /* fill-in form initialization code */

   /* show the first form */
  fl_show_form(fd_xmemos->xmemos,FL_PLACE_FREE,FL_FULLBORDER,"xmemos");
  fl_set_input_return(fd_xmemos->input, FL_RETURN_ALWAYS);
  /**********************************************/
  /* reserve le memoire et initialise les pages */
  /**********************************************/
  for(i = 0; i < MAX_PAGES; i++)
    {
      if(mallocPage(i))
	{
	  clearPage(i);
	  readPage(i);
          setColButton(i);
	}
    }
  g_autosave = 1;
  g_curPage = 0;
  pageToInput(0);
  
  fl_do_forms();
  return 0;
}
