/*
 *   ksendfax - a interface to fax-packages
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef KSendFax_included
#define KSendFax_included

#include <qfiledlg.h>
#include <kprocess.h>
#include "ksendfaxdata.h"
#include "loglistbox.h"

class KSendFax : public KSendFaxData
{
    Q_OBJECT

public:

    enum {
        OPEN_READWRITE 	= 1, 
        OPEN_READONLY 	= 2, 
        OPEN_INSERT	= 4
    };
    bool
        showPB;

    KSendFax(QWidget* parent = NULL, const char* name = NULL);
    virtual ~KSendFax();
    int SendFax();
    int ShowJobs();
    int RemoveJob();
    int SetFileName(const char* fname);
    void saveOptions();
    int totMinimumHeight();
    bool pbAdd();
    bool pbModify();
    bool pbDelete();
    bool pbSave();
    void readConfig();
    void showFilelist(bool flag);

private:
    QString
        sendcmd,
        showcmd,
        removecmd,
        logdir,
        groffcmd,
        phonebook,
        current_directory;
    LogListBox
        *show_listbox,
        *remove_listbox,
        *error_listbox;
    int
        numsent,
        updateSeconds;
    
    QFileDialog* getFileDialog(const char* captiontext);
    int SetFileName();

protected slots:
    void SendFaxCB();
    void BrowseFileCB();
    void ReadStderr(KProcess *, char *buffer, int buflen);
    void ReadStdout(KProcess *, char *buffer, int buflen);
    void SendFaxDone(KProcess*);
    void pbSelectCB(const char *item);
    void AddFileCB();
    void RemoveFileCB();

protected:
    virtual void resizeEvent (QResizeEvent *rse);    
    void pbLoad(const char *fname);
    void setPos(QLabel *lab, QLineEdit *le);
    const char *askID();

signals:
    void ExitKSendFax();
};
#endif // KSendFax_included
