/**********************************************************************

	--- Qt Architect generated file ---

	File: LogListBox.cpp
	Last generated: Tue Feb 24 17:02:03 1998

 *********************************************************************/

#include <qapp.h>
#include <qfile.h>
#include <qtstream.h>
#include <qstring.h>
#include <qmsgbox.h>

#include <kapp.h>

#include "loglistbox.h"
#include "myprocess.h"

extern QString debugFlag;

#define Inherited LogListBoxData

LogListBox::LogListBox(QWidget* parent,	const char* name)
	:Inherited( parent, name )
{
    if (name)
        setCaption(name);
    timerID=0;
    timerUpdate=0;
    clearBox = true;
    connect(closeButton, SIGNAL(clicked()), SLOT(hideBox()));
}


LogListBox::~LogListBox()
{
}

void LogListBox::load(const char *fileName)
{
    QFile f( fileName );
    if ( !f.open( IO_ReadOnly ) )
        return;

    logListBox->setAutoUpdate( FALSE );
    logListBox->clear();

    QTextStream t(&f);
    while ( !t.eof() ) {
        QString s = t.readLine();
        logListBox->insertItem( s );
    }
    f.close();

    logListBox->setAutoUpdate( TRUE );
    logListBox->repaint();
    setCaption( fileName );
}

void LogListBox::insertItem(const char *text)
{
    logListBox->insertItem(text);
    logListBox->repaint();
}

void LogListBox::clear()
{
    logListBox->clear();
}

void LogListBox::CommandDone(KProcess *proc)
{
    if (!proc)
        return;
    MyProcess *mproc = (MyProcess*)proc;
    QString
        s;
    QTextStream
        tse(mproc->stderr_str,IO_ReadOnly),
        tso(mproc->stdout_str,IO_ReadOnly);

    if (!debugFlag.isEmpty()) {
        printf("Called CommandDone\n");
        fprintf(stderr,"SSE:%s\n",mproc->stderr_str.data());
        fprintf(stdout,"SSO:%s\n",mproc->stdout_str.data());
    }
    if(proc->isRunning())
        proc->kill();
    delete proc;
    if (clearBox)
        clear();
    s = tso.readLine();
    while(!tso.eof()) {
        insertItem(s);
        s = tso.readLine();
    }
    if (!s.isEmpty())
        insertItem(s);
    s = tse.readLine();
    while(!tse.eof()) {
        insertItem(s);
        s = tse.readLine();
    }
    if (!s.isEmpty())
        insertItem(s);
    show();
}

void LogListBox::setCommand(const char *cmd)
{
    command = cmd;
}

bool LogListBox::activateCommand(bool clear_box=true)
{
    clearBox = clear_box;
    if (command.isEmpty())
        return false;

    if (!timerID && (timerUpdate > 0)) {
        if (!(timerID = startTimer(timerUpdate)))
            QMessageBox::warning(this,"KSendFax",i18n("Cannot start TIMER"));
    }

    MyProcess
        *proc = new MyProcess;

    *proc << command.data();
    connect(proc, SIGNAL(processExited(KProcess *)),this,
            SLOT(CommandDone(KProcess*)));

    bool result = proc->start(KProcess::NotifyOnExit , KProcess::All);
    if(!result){
        QString str;
        str.sprintf(i18n("Cannot start a new program\nfork() failed."));
        QMessageBox::critical(this,"KSendFax",str.data());
        if (proc) {
            if(proc->isRunning())
                proc->kill();
            delete proc;
        }
        return false;
    }
    return true;
}

void LogListBox::deactivateCommand()
{
    if (timerID)
        killTimer(timerID);
    timerID = 0;
}

void LogListBox::timerEvent(QTimerEvent *)
{
    activateCommand();
}

void LogListBox::setTimerUpdate(int t)
{
    timerUpdate = t;
}

void LogListBox::hideBox()
{
    if (timerID > 0)
        killTimer(timerID);
    timerID = 0;
    hide();
}

const char *LogListBox::text(int index)
{
    return logListBox->text(index);
}

int LogListBox::currentItem() const
{
    return logListBox->currentItem();
}

void LogListBox::setCurrentItem(int index)
{
    logListBox->setCurrentItem(index);
}
