/*
 *   ksendfax - a interface to fax-packages
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "mainwidget.h"
#include <kapp.h>
#include "ksendfax_version.h"

QString debugFlag;
int oneShotFlag = false;

int main( int argc, char **argv )
{
    int v;
    
    KApplication a( argc, argv );

    for (v=1; v<argc; v++){
        if (QString("-version") == argv[v]) {
            printf(KSENDFAX_VERSION);
            printf("\n");
            printf("Copyright (C) 1998 Jrgen Vigna (jug@sad.it)\n\n");
            exit(0);
        } else if (QString("-oneshot") == argv[v]) {
            oneShotFlag = true;
        } else if (*argv[v] == '-') {
            printf(KSENDFAX_VERSION);
            printf("\n");
            printf("Copyright (C) 1998 Jrgen Vigna (jug@sad.it)\n\n");
            printf(i18n("Frontend for sending faxes for the KDE Desktop Environment\n"));
            printf(i18n("Permitted arguments:\n"));
            printf(i18n("-oneshot   : exits ksendfax after sending one fax\n"));
            printf(i18n("-help      : displays this message\n"));
            printf(i18n("-version   : displays the version number\n"));
            printf(i18n("<filename> : inserts this filename in the File-Input-Field\n"));
            printf(i18n("And all KApplication and Qt-toolkit arguments.\n"));
            exit(0);
        } else
            break;
    }

    MainWidget *w;
    w = ((argc>1) && (v < argc)) ?
        new MainWidget(argv[v]) : new MainWidget();
    a.setMainWidget( w );
    w->show();
    kapp->getConfig()->setGroup("ksendfax");
    return a.exec();
}
