/*
 *   ksendfax - a interface to fax-packages
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qfiledlg.h> 
#include <qaccel.h> 
#include <qmsgbox.h>
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kiconloader.h>
#include <kapp.h>
#include <kurl.h>
#include <kstdaccel.h>
#include "mainwidget.h"
#include "ksendfax.h"

MainWidget::MainWidget(char *fname, QWidget *, const char *name)
	: KTopLevelWidget(name)
{
    kapp->getConfig()->setGroup("ksendfax");
    showToolbar = kapp->getConfig()->readNumEntry("show_toolbar",true);
    showFilelist = kapp->getConfig()->readNumEntry("show_filelist",false);
    initMenu();
    ksendfax_widget = new KSendFax(this,0);
    connect (ksendfax_widget, SIGNAL(ExitKSendFax()),this,
             SLOT(ExitKSendFax()));
    setView(ksendfax_widget);
    ksendfax_widget->show();
    ksendfax_widget->showFilelist(showFilelist);
    setCaption(kapp->getCaption());
    setMinimumSize(ksendfax_widget->minimumSize().width(),
                   ksendfax_widget->minimumSize().height()+
                   toolbar->height() + menu->height());
    setGeometry(x(), y(),ksendfax_widget->width(),
                ksendfax_widget->height()+toolbar->height()+menu->height());
    if (!ksendfax_widget->showPB) {
        phonebook->setItemChecked(ID_PB_SHOW,false);
        setFixedSize(ksendfax_widget->minimumSize().width(),
                     ksendfax_widget->minimumSize().height()+
                     toolbar->height()+menu->height());
    } else {
        setMinimumSize(ksendfax_widget->minimumSize().width(),
                       ksendfax_widget->totMinimumHeight() +
                       toolbar->height()+menu->height()+10);
        toolbar->setItemEnabled(ID_PB_MODIFY,TRUE);
        toolbar->setItemEnabled(ID_PB_DELETE,TRUE);
    }
    if (fname)
        ksendfax_widget->SetFileName(fname);
    // drag'n drop support for files
    KDNDDropZone *dropZone = new KDNDDropZone(this , DndURL);
    connect(dropZone, SIGNAL(dropAction( KDNDDropZone *)), 
            this, SLOT(slotDropEvent(KDNDDropZone *)));
}

MainWidget::~MainWidget()
{
}

int MainWidget::initMenu() {

    QPopupMenu *file = new QPopupMenu;
    file->insertItem(i18n("&Send Fax..."), ID_FILE_SEND);
    file->insertItem(i18n("Sho&w Jobs"), ID_FILE_SHOW);
    file->insertItem(i18n("&Remove Job"), ID_FILE_REMOVE);
    file->setAccel(CTRL+Key_S, ID_FILE_SEND);
    file->setAccel(CTRL+Key_W, ID_FILE_SHOW);
    file->setAccel(CTRL+Key_R, ID_FILE_REMOVE);
    file->insertSeparator();
    file->insertItem(i18n("&Quit"), ID_FILE_QUIT);
    file->setAccel(CTRL+Key_Q, ID_FILE_QUIT);
    
    options = new QPopupMenu;
    options->insertItem(i18n("&Preferences"), ID_OP_PREF);
    options->insertItem(i18n("&Toggle Toolbar"), ID_OP_TOOLBAR);
    if (showFilelist)
        options->insertItem(i18n("Hide &Filelist"), ID_OP_FILELIST);
    else
        options->insertItem(i18n("Show &Filelist"), ID_OP_FILELIST);
    options->insertItem(i18n("&Save Options"), ID_OP_SAVE);

    phonebook = new QPopupMenu;
    phonebook->setCheckable(true);
    phonebook->insertItem(i18n("&Show"), ID_PB_SHOW);
    phonebook->setItemChecked(ID_PB_SHOW,true);
    phonebook->setAccel(CTRL+Key_P, ID_PB_SHOW);
    phonebook->insertItem(i18n("&Add"), ID_PB_ADD);
    phonebook->insertItem(i18n("&Modify"), ID_PB_MODIFY);
    phonebook->insertItem(i18n("&Delete"), ID_PB_DELETE);
    phonebook->insertItem(i18n("&Save"), ID_PB_SAVE);
    
    QPopupMenu *help = new QPopupMenu;
    help->insertItem(i18n("&Help"), ID_HELP_HELP);
    help->setAccel(Key_F1, ID_HELP_HELP);
    help->insertSeparator();
    help->insertItem(i18n("&About"), ID_HELP_ABOUT);

    menu = new KMenuBar(this);
    menu->insertItem(i18n("&File"), file);
    menu->insertItem(i18n("&Options"), options);
    menu->insertItem(i18n("&Phonebook"), phonebook);
    menu->insertSeparator();
    menu->insertItem(i18n("&Help"), help);

    menu->show();
    setMenu(menu);
    
    connect (menu, SIGNAL (activated (int)), SLOT(menuCallback (int)));

    QString
        ddir = kapp->kde_datadir();
    ddir += "/ksendfax/toolbar";
    KIconLoader *loader = kapp->getIconLoader();
    loader->insertDirectory(0,ddir);
    toolbar = new KToolBar(this);
    
    toolbar->insertButton(loader->loadIcon("exit.xpm"),ID_FILE_QUIT, TRUE,
                          i18n("Quit"));
    toolbar->insertButton(loader->loadIcon("faxsend.xpm"),ID_FILE_SEND, TRUE,
                          i18n("Send Fax"));
    toolbar->insertButton(loader->loadIcon("faxshow.xpm"),ID_FILE_SHOW, TRUE,
                          i18n("Show Jobs"));
    toolbar->insertButton(loader->loadIcon("faxremove.xpm"),ID_FILE_REMOVE,
                          TRUE, i18n("Remove Job"));
    toolbar->insertSeparator();
    toolbar->insertButton(loader->loadIcon("page.xpm"),ID_PB_SHOW,
                          TRUE, i18n("Show/Hide Phonebook"));
    toolbar->insertButton(loader->loadIcon("editpaste.xpm"),ID_PB_ADD, TRUE,
			  i18n("Add to Phonebook"));
    toolbar->insertButton(loader->loadIcon("editcopy.xpm"),ID_PB_MODIFY,
                          FALSE, i18n("Modify Phonebook"));
    toolbar->insertButton(loader->loadIcon("editcut.xpm"),ID_PB_DELETE,
                          FALSE, i18n("Delete from Phonebook"));
    toolbar->insertButton(loader->loadIcon("filefloppy.xpm"), ID_PB_SAVE,
                          FALSE, i18n("Save Phonebook"));
    
    addToolBar(toolbar);
    toolbar->setBarPos(KToolBar::Top);
    toolbar->show();
    if (!showToolbar)
        enableToolBar();
    connect(toolbar, SIGNAL(clicked(int)), this, SLOT(menuCallback(int)));
    updateRects();
    return 0;
}

void MainWidget::ExitKSendFax()
{
    kapp->exit();
}

void MainWidget::menuCallback(int item)
{
    switch(item) {
      case ID_FILE_SEND: {
          ksendfax_widget->SendFax();
          break;
      }
      
      case ID_FILE_SHOW: {
          ksendfax_widget->ShowJobs();
          break;
      }
      
      case ID_FILE_REMOVE: {
          ksendfax_widget->RemoveJob();
          break;
      }
      
      case ID_FILE_QUIT: {
          kapp->exit();
          break;
      }
      case ID_OP_PREF: {
          Preferences *pref = new Preferences;
          pref->exec();
          delete pref;
          ksendfax_widget->readConfig();
          break;
      }
      case ID_OP_TOOLBAR: {
          enableToolBar();
          showToolbar = !showToolbar;
          break;
      }
      case ID_OP_FILELIST: {
          showFilelist = !showFilelist;
          ksendfax_widget->showFilelist(showFilelist);
          if (ksendfax_widget->showPB) {
              setMaximumSize(ksendfax_widget->maximumSize().width(),
                             ksendfax_widget->maximumSize().height());
              setMinimumSize(ksendfax_widget->minimumSize().width(),
                             ksendfax_widget->totMinimumHeight() +
                             toolbar->height()+menu->height()+10);
              setGeometry(x(), y(),
                          ksendfax_widget->width(),
                          ksendfax_widget->height() +
                          toolbar->height()+menu->height());
          } else {
              setFixedSize(ksendfax_widget->minimumSize().width(),
                           ksendfax_widget->minimumSize().height()+
                           toolbar->height()+menu->height());
          }
          if (showFilelist)
              options->changeItem(i18n("Hide &Filelist"), ID_OP_FILELIST);
          else
              options->changeItem(i18n("Show &Filelist"), ID_OP_FILELIST);
          break;
      }
      case ID_OP_SAVE: {
          kapp->getConfig()->setGroup("ksendfax");
          kapp->getConfig()->writeEntry("show_toolbar",showToolbar);
          kapp->getConfig()->writeEntry("show_filelist",showFilelist);
          ksendfax_widget->saveOptions();
          break;
      }
      case ID_PB_SHOW: {
          if (ksendfax_widget->showPB) {
              ksendfax_widget->adjustSize();
              ksendfax_widget->showPB=false;
              setFixedSize(ksendfax_widget->minimumSize().width(),
                           ksendfax_widget->minimumSize().height()+
                           toolbar->height()+menu->height());
              toolbar->setItemEnabled(ID_PB_MODIFY,FALSE);
              toolbar->setItemEnabled(ID_PB_DELETE,FALSE);
          } else {
              ksendfax_widget->adjustSize();
              ksendfax_widget->showPB = true;
              setMaximumSize(ksendfax_widget->maximumSize().width(),
                             ksendfax_widget->maximumSize().height());
              setMinimumSize(ksendfax_widget->minimumSize().width(),
                             ksendfax_widget->totMinimumHeight() +
                             toolbar->height()+menu->height()+10);
                             
              setGeometry(x(), y(),
                          ksendfax_widget->width(),
                          ksendfax_widget->height() +
                          toolbar->height()+menu->height());
              toolbar->setItemEnabled(ID_PB_MODIFY,TRUE);
              toolbar->setItemEnabled(ID_PB_DELETE,TRUE);
          }
          phonebook->setItemChecked(ID_PB_SHOW,ksendfax_widget->showPB);
          break;
      }
      case ID_PB_ADD: {
          if (ksendfax_widget->pbAdd())
              toolbar->setItemEnabled(ID_PB_SAVE,TRUE);
          break;
      }
      case ID_PB_MODIFY: {
          if (ksendfax_widget->pbModify())
              toolbar->setItemEnabled(ID_PB_SAVE,TRUE);
          break;
      }
      case ID_PB_DELETE: {
          if (ksendfax_widget->pbDelete())
              toolbar->setItemEnabled(ID_PB_SAVE,TRUE);
          break;
      }
      case ID_PB_SAVE: {
          if (ksendfax_widget->pbSave())
              toolbar->setItemEnabled(ID_PB_SAVE,FALSE);
          break;
      }
      case ID_HELP_HELP: {
          KApplication::getKApplication()->invokeHTMLHelp("", "");
          break;
      }
      case ID_HELP_ABOUT: {
          QMessageBox::about(0,
              i18n("About"),
              i18n("KSendFax " VERSION "\n\nCopyright 1998\n"
                   "by Jrgen Vigna\njug@sad.it"));
          break;
      }
    }
}

void MainWidget::cancelPrefCB()
{
    pref->hide();
}

void MainWidget::slotDropEvent(KDNDDropZone * _dropZone)
{
    QStrList &list = _dropZone->getURLList();

    // we can only handle one file
    QString s = list.first();
    QFileInfo ff(KURL(s).path());

    if (KURL(s).isLocalFile() || !ff.exists() || !ff.isFile())
        ksendfax_widget->SetFileName(KURL(s).path());
}
