/*
 *   ksendfax - a interface to fax-packages
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _HEXWIDGET_H
#define _HEXWIDGET_H

#include <ktopwidget.h>
#include <ktoolbar.h>
#include "ksendfax.h"
#include "preferences.h"
#include <drag.h>

#define ID_FILE_SEND	1
#define ID_FILE_SHOW	2
#define ID_FILE_REMOVE	3
#define ID_FILE_QUIT	9

#define ID_PB_SHOW	30
#define ID_PB_ADD	31
#define ID_PB_MODIFY	32
#define ID_PB_DELETE	33
#define ID_PB_SAVE	34

#define ID_OP_PREF	50
#define ID_OP_TOOLBAR	51
#define ID_OP_FILELIST	52
#define ID_OP_SAVE	55

#define ID_HELP_HELP	90
#define ID_HELP_ABOUT	91

class KPanner;
class QToolTipGroup;

class MainWidget : public KTopLevelWidget {
    Q_OBJECT
    
public:

    MainWidget(char *fname=0, QWidget *parent=0,const char *name=0 );
    ~MainWidget();
    
public slots:
    void menuCallback(int);

protected slots:
    void slotDropEvent(KDNDDropZone * _dropZone);
    void ExitKSendFax(); 
    
private:
    KToolBar *toolbar;
    KMenuBar *menu;
    QPopupMenu
        *options,
        *phonebook;
    KSendFax *ksendfax_widget;
    KConfig  *kconfig;
    bool
        showFilelist,
        showToolbar;
    Preferences *pref;

protected:
    void bindKeys();
    int initMenu();
    void saveOptions();
    void cancelPrefCB();
};

#endif
