/*
 *   ksendfax - a interface to fax-packages
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MyProcess_included
#define MyProcess_included

#include <kprocess.h>

class MyProcess : public KShellProcess
{
    Q_OBJECT

public:
    MyProcess(const char *shellname=NULL,bool init=true);
    void setLocalData(const char *data);
    const char *localData();
    int
        row;
    QString
        stderr_str,
        stdout_str;

protected slots:
    void ReadStderr(KProcess *, char *buffer, int buflen);
    void ReadStdout(KProcess *, char *buffer, int buflen);

private:
    QString
        descStr;
};
#endif // MyProcess_included
