/**********************************************************************

	--- Qt Architect generated file ---

	File: preferences.cpp
	Last generated: Wed Mar 4 15:23:57 1998

 *********************************************************************/

#include <qregexp.h>
#include <kapp.h>
#include <kconfig.h>
#include "preferences.h"

#define Inherited PreferencesData

Preferences::Preferences(QWidget* parent,const char* name)
	:Inherited( parent, name )
{
    setCaption(i18n("Fax Preferences"));
    okButton->setDefault(TRUE);
    readConfig();
    // set labels for i18n
    labelCmdBox->setText(i18n("Commands"));
    labelFaxCommand->setText(i18n("Send Fax:"));
    labelShowCommand->setText(i18n("Show Jobs:"));
    labelRemoveCommand->setText(i18n("Remove Job:"));
    labelUpdateSeconds->setText(i18n("Update all n seconds:"));
    labelPhonebook->setText(i18n("Phonebook:"));
    okButton->setText(i18n("Ok"));
    cancelButton->setText(i18n("Cancel"));
    setPos(labelFaxCommand,InputFaxCommand);
    setPos(labelShowCommand,InputShowCommand);
    setPos(labelRemoveCommand,InputRemoveCommand);
    setPos(labelUpdateSeconds,InputUpdateSeconds);
    setPos(labelPhonebook,InputPhonebook);
}


Preferences::~Preferences()
{
}

void Preferences::readConfig()
{
    KConfig *config = kapp->getConfig();

    config->setGroup("ksendfax");
    QString str;
    str = config->readEntry("send_command");
    if (!str.isEmpty())
        InputFaxCommand->setText(str);
    str = config->readEntry("show_command");
    if (!str.isEmpty())
        InputShowCommand->setText(str);
    str = config->readEntry("remove_command");
    if (!str.isEmpty())
        InputRemoveCommand->setText(str);
    str = config->readNumEntry("update_seconds");
    if (!str.isEmpty())
        InputUpdateSeconds->setText(str);
    str = config->readEntry("phonebook");
    if (!str.isEmpty())
        InputPhonebook->setText(str);
}

void Preferences::okPressed()
{
    KConfig *config = kapp->getConfig();

    config->setGroup("ksendfax");
    QString str = InputFaxCommand->text();
    str.replace(QRegExp("\\$\\$"),"@@");
    if (!str.isEmpty())
        config->writeEntry("send_command", str);
    str = InputShowCommand->text();
    str.replace(QRegExp("\\$\\$"),"@@");
    if (!str.isEmpty())
        config->writeEntry("show_command", str);
    str = InputRemoveCommand->text();
    str.replace(QRegExp("\\$\\$"),"@@");
    if (!str.isEmpty())
        config->writeEntry("remove_command", str);
    str = InputUpdateSeconds->text();
    if (!str.isEmpty())
        config->writeEntry("update_seconds", str);
    str = InputPhonebook->text();
    if (!str.isEmpty())
        config->writeEntry("phonebook", str);
    config->sync();
    accept();
}

void Preferences::setPos(QLabel *lab, QLineEdit *le)
{
    int pos, diff;

    pos = lab->x() + lab->width() + 5;
    diff = pos - le->x();
    if (diff > 0)
        le->setGeometry(pos, le->y(), le->width() - diff, le->height());
}
