#include <stdio.h>
#include <stdlib.h>

#include "forms.h"
#include "xfaxdefs.h"

char *BuildAliasFile(int check)
{ 
   static char string[MAXSTRING];
   char *home = getenv("HOME");
   
   if(home != NULL)
     sprintf(string,"%s/.%s",home,XFAXALIASES);
   if(check)
   {
      if(CheckForExistence(string) != 0) /* if file doesn't exist */
	sprintf(string,"%s/%s",FAXBASE,XFAXALIASES); /* use system wide */
   }
   
   return string;
}

void BrowserDblClick(FL_OBJECT *ob, long data)
{
   PasteAlias(ob,data);
   AliasesClose(ob,data);
}

void BrowseAliases(FL_OBJECT *ob, long data)
{  FILE *aliases;
   char *ptr,string[MAXSTRING];

   fl_set_browser_fontsize(fd_Aliases->AliasViewer,14);
   
   if((aliases = fopen(BuildAliasFile(1),"r")) == NULL)
   {  
      fl_show_message("","Warning: No aliases found","");
      return;
   }
   
   fl_deactivate_form(fd_Xfax->Xfax);
   
   fl_clear_browser(fd_Aliases->AliasViewer);
   
   while(ptr = fgets(string,MAXSTRING -1,aliases), ! feof(aliases))
   {
      if(string[strlen(string)-1]=='\n')
	string[strlen(string)-1]=0;
      /* remove trailing LF to avoid extra line in v0.86 library */
      
      fl_addto_browser(fd_Aliases->AliasViewer,ptr);
   }
   fclose(aliases);
   
   fl_show_form(fd_Aliases->Aliases,
		FL_PLACE_MOUSE|FL_FREE_SIZE,FL_FULLBORDER,"Aliases");
   
   fl_set_browser_dblclick_callback(fd_Aliases->AliasViewer,BrowserDblClick,0);
}

void AliasesClose(FL_OBJECT *ob, long data)
{
   fl_activate_form(fd_Xfax->Xfax);
   fl_hide_form(fd_Aliases->Aliases);
}

void AddAlias (FL_OBJECT *ob, long data)
{  FILE *aliases;
   const char *name,*number;
   char *string;

   string=BuildAliasFile(0);
   
   if((aliases = fopen(string,"a")) == NULL)   
   {  
      fl_show_alert("","Can't open alias file !","",1);
      return;
   }
   else
   {
      name   = fl_get_input(fd_Xfax->Name);
      number = fl_get_input(fd_Xfax->Number);
      if(strlen(number) == 0)
      {
	 fl_show_message("","Nothing to add !","");
	 return;
      }
      
      fprintf(aliases,"%s : %s\n",name,number);
      fclose(aliases);
      fl_show_message(name,"Added to aliases database","");
   }
}

void PasteAlias (FL_OBJECT *ob, long data)
{
   int linenr;
   char *number,name[MAXSTRING];
   
   if((linenr = fl_get_browser(fd_Aliases->AliasViewer)) > 0)
   {
      strncpy(name,fl_get_browser_line(fd_Aliases->AliasViewer,linenr),MAXSTRING -1);
      if((number = strchr(name,':')) == NULL)
      {
	 fl_show_message("","Alias database corrupt !","");
	 return;
      }
      *number++ = '\0';
      while(*number == ' ') number++;
      fl_set_input(fd_Xfax->Number, number);
      fl_set_input(fd_Xfax->Name, name);
   }
   else
     fl_show_message("","No alias selected !","");
}

void SaveAliases(FL_OBJECT *brw)
{  FILE *aliases;
   int i,max;
   char *string;

   string = BuildAliasFile(0);
      
   if((aliases = fopen(string,"w")) == NULL)   
   {  
      fl_show_alert("","Can't open alias file !","",1);
      return;
   }
   else
   {
      max = fl_get_browser_maxline(brw);
      for(i=1;i<=max;i++)
	fprintf(aliases,"%s\n",fl_get_browser_line(brw,i));
      fclose(aliases);
   }
}

void RemoveAlias(FL_OBJECT *ob, long data)
{
   int linenr;
   
   if((linenr = fl_get_browser(fd_Aliases->AliasViewer)) > 0)
     fl_delete_browser_line(fd_Aliases->AliasViewer,linenr);
   else
     fl_show_message("","No alias selected !","");

   SaveAliases(fd_Aliases->AliasViewer);
}

