#include <fcntl.h>
#include <unistd.h>

#include "forms.h"
#include "xfaxdefs.h"

void AddLogInfo(FL_OBJECT *ob, long pipe)
{
   char message[MAXLINE],*ptr;
   static int count=1;
   
   fl_freeze_form(fd_Xfax->Xfax); /* avoid heavy system load */
   
   ptr=message;
   while(read(pipe,ptr,1) > 0)
   {
      count++;
      
      if(*ptr == '\n' || count >= MAXLINE - 1 )
      {
	 if(*ptr == '\n') *ptr++=0; /* remove LF: v0.86 problem */
	 else             *++ptr=0; 

	 count=1;
	 fl_addto_browser(fd_LogView->Viewer,message);
	 *message=0;
	 ptr=message;
      }
      else ptr++;
   	}
   
   *ptr=0;
   fl_addto_browser(fd_LogView->Viewer,message);
   
   fl_unfreeze_form(fd_Xfax->Xfax);
}

void RedirectIO(FILE *iohandle)
{
   int pipepair[2];
   long modes;

   /* Provide a mechanism to redirect errors from outside to our Browser */
   pipe(pipepair);
   close(fileno(iohandle));
   dup(pipepair[1]);       /* set input side from pipe to iohandle */
   setbuf(iohandle,NULL);

   /* force non-blocking mode so we can always read from this fd */
   modes = fcntl(pipepair[0],F_GETFL);
   fcntl(pipepair[0],F_SETFL, modes | O_NDELAY);

   /* And connect to the browser */
   fl_add_io_callback(pipepair[0],FL_READ,
		      (FL_IO_CALLBACK)AddLogInfo,(void *)pipepair[0]);
}

void LogViewOpen(FL_OBJECT *ob, long data)
{
   fl_show_form(fd_LogView->LogView,
		FL_PLACE_MOUSE|FL_FREE_SIZE,FL_FULLBORDER,"LogView");
}

void LogViewClose(FL_OBJECT *ob, long data)
{
   fl_hide_form(fd_LogView->LogView);
}

void LogViewWriteFile(FL_OBJECT *ob, long parent)
{
   FILE *output;
   char *filename;
   int x,count;
   
   count = fl_get_browser_maxline(fd_LogView->Viewer);
   
   filename = (char *)fl_show_fselector("Set Outputfile","","*","");
   if (filename == NULL)
     return;
   
   if((output = fopen(filename,"w")) == NULL)
   {
      
      fl_show_message("","Can't open output file","");
      return;
   }
   
   for(x=1;x<=count;x++) /* browser starts with 1 */
   {
      
      fputs(fl_get_browser_line(fd_LogView->Viewer,x),output);
      fputc('\n',output);
   }
   
   fclose(output);
   fl_show_message("","Browser contents written to file","");
}

