#include <stdio.h>
#include <stdlib.h>
#include "forms.h"

#include "xfaxdefs.h"
#include "version.h"

char *UserResourceFile(int check)
{
   static char string[MAXSTRING];
   char *home = getenv("HOME");
   
   if(home != NULL)
     sprintf(string,"%s/.%s",home,XFAXRESOURCES);
   if(check)
   {
      if(CheckForExistence(string) != 0)
      {	fl_show_message("Warning: No personal resources are found :",
			"Please set these using the 'From Info' option,",
			"or else faxes won't contain any sender information.");
	 *string = 0;
      }
   }
   return string;
}

char *SystemResourceFile(int check)
{
   static char string[MAXSTRING];
   
   sprintf(string,"%s/%s",FAXBASE,XFAXRESOURCES); /* use system wide */
   
   if(check)
   {
      if(CheckForExistence(string) != 0)
      {	fl_show_message("","Warning: No system resources found,",
			"Falling back to precompiled defaults.");
	 *string = 0;
      }
   }
   return string;
}

char *ReadString(const char *label,char *value,FILE *rcfile)
{  char string[MAXSTRING];
   char *ptr;
   int count;
   rewind(rcfile);
   
   while(1)
   {
      fgets(string,MAXSTRING,rcfile);
      if(feof(rcfile))
      {
	 *value = 0;
	 return NULL;
      }
      
      /* Include ":" in compare string by setting count 1 higher to avoid
       * confusing resources starting with the same string ! */
      for(ptr=string,count=1; *ptr != ':' && *ptr != '\0';ptr++,count++);
      if(! strncmp(string,label,count))
      {
	 sscanf(string,label,value);
	 break;
      }
   }
   
   return value;
}

void WriteString(const char *label,const char *value,FILE *rcfile)
{
   if(strlen(value) > 0)
     fprintf(rcfile,label,value);
}

Xfaxrc *LoadUserInfo()
{
   FILE *rcfile;
   static Xfaxrc info;

   strcpy(info.FrontPageFlag,"True"); /* enable by default */

   if((rcfile = fopen(UserResourceFile(1),"r")) == NULL)
   {
      if((rcfile = fopen(SystemResourceFile(1),"r")) == NULL)
	return &info;
   }
   
   ReadString("AsciiCmd: %[^\n]",info.AsciiCmd,rcfile);
   ReadString("Department: %[^\n]"   ,info.Department,rcfile);
   ReadString("Editor: %[^\n]",  info.Editor,rcfile);
   ReadString("Email: %[^\n]"   ,info.Email,rcfile);
   ReadString("EmailFlag: %[^\n]", info.EmailFlag,rcfile);
   ReadString("FaxSend: %[^\n]" ,  info.FaxSend,rcfile);
   ReadString("FaxPrint: %[^\n]",info.FaxPrint,rcfile);
   ReadString("FrontPageFlag: %[^\n]",info.FrontPageFlag,rcfile);
   ReadString("GifCmd: %[^\n]"  ,info.GifCmd,rcfile);
   ReadString("Header: %[^\n]"  ,info.Header,rcfile);
   ReadString("Name: %[^\n]"    ,info.Name,rcfile);
   ReadString("PSCmd: %[^\n]"   ,info.PSCmd,rcfile);
   ReadString("SpoolDir: %[^\n]",info.SpoolDir,rcfile);
   ReadString("Title: %[^\n]"   ,info.Title,rcfile);
   ReadString("G3ToXpm: %[^\n]"  ,info.G3ToXpm,rcfile);
   fclose(rcfile);

   return &info;
}

void SaveUserInfo(const Xfaxrc *info)
{
   FILE *rcfile;
   char *string;
   
   string = UserResourceFile(0);
   if(strlen(string) == 0 || (rcfile = fopen(string,"w")) == NULL)
   {  fl_show_message("","Alert: Can't write resource information !","");
      return;
   }
   WriteString("AsciiCmd: %s\n"  ,info->AsciiCmd,rcfile);
   WriteString("Department: %s\n",info->Department,rcfile);
   WriteString("Editor: %s\n"    ,info->Editor,rcfile);
   WriteString("Email: %s\n"     ,info->Email,rcfile);
   WriteString("EmailFlag: %s\n" ,info->EmailFlag,rcfile);
   WriteString("FaxSend: %s\n"   ,info->FaxSend,rcfile);
   WriteString("FaxPrint: %s\n"  ,info->FaxPrint,rcfile);
   WriteString("FrontPageFlag: %s\n",info->FrontPageFlag,rcfile);
   WriteString("GifCmd: %s\n"    ,info->GifCmd,rcfile);
   WriteString("Header: %s\n"    ,info->Header,rcfile);
   WriteString("Name: %s\n"      ,info->Name,rcfile);
   WriteString("PSCmd: %s\n"     ,info->PSCmd,rcfile);
   WriteString("SpoolDir: %s\n"  ,info->SpoolDir,rcfile);
   WriteString("Title: %s\n"     ,info->Title,rcfile);
   WriteString("G3ToXpm: %s\n"   ,info->G3ToXpm,rcfile);
   
   fclose(rcfile);
}

void InitFromWin(FD_FromWin *fw)
{
   fw->vdata = (void *)info;
   
   fl_deactivate_form(fd_Xfax->Xfax);
   
   fl_set_input(fw->Name, info->Name); 
   fl_set_input(fw->Title,info->Title);
   fl_set_input(fw->Department,info->Department);
   fl_set_input(fw->Email,info->Email);
   
   fl_show_form(fw->FromWin,FL_PLACE_CENTER,FL_TRANSIENT,"FromWin");
}

void InitSystemWin(FD_SystemWin *fw)
{
   fw->vdata = (void *)info;
   
   fl_deactivate_form(fd_Xfax->Xfax);
   
   fl_set_input(fw->AsciiCmd,info->AsciiCmd);
   fl_set_input(fw->Editor,  info->Editor);
   fl_set_input(fw->FaxSend,   info->FaxSend);
   fl_set_input(fw->FaxPrint,info->FaxPrint);
   fl_set_input(fw->GifCmd,  info->GifCmd);
   fl_set_input(fw->PSCmd,   info->PSCmd); 
   fl_set_input(fw->SpoolDir,info->SpoolDir);
   fl_set_input(fw->G3ToXpm,  info->G3ToXpm);
   
   fl_show_form(fw->SystemWin,FL_PLACE_CENTER,FL_TRANSIENT,"SystemWin");
}

/* callbacks for form FromWin */

void FromOK(FL_OBJECT *ob, long data)
{
   Xfaxrc *info = (Xfaxrc *)fd_FromWin->vdata;
   
   strncpy(info->Name ,fl_get_input(fd_FromWin->Name ),MAXSTRING - 1);
   strncpy(info->Title,fl_get_input(fd_FromWin->Title),MAXSTRING - 1);
   strncpy(info->Department,fl_get_input(fd_FromWin->Department),MAXSTRING - 1);
   strncpy(info->Email,fl_get_input(fd_FromWin->Email),MAXSTRING - 1);

   SaveUserInfo(info);
   
   fl_hide_form(fd_FromWin->FromWin);
   fl_activate_form(fd_Xfax->Xfax);
}

void FromCancel(FL_OBJECT *ob, long data)
{
   fl_hide_form(fd_FromWin->FromWin);
   fl_activate_form(fd_Xfax->Xfax);
}

/* callbacks for form System */

void SystemOK(FL_OBJECT *ob, long data)
{
   Xfaxrc *info = (Xfaxrc *)fd_SystemWin->vdata;
   
   strncpy(info->AsciiCmd,fl_get_input(fd_SystemWin->AsciiCmd),MAXSTRING - 1);
   strncpy(info->Editor  ,fl_get_input(fd_SystemWin->Editor),MAXSTRING - 1);
   strncpy(info->FaxSend ,fl_get_input(fd_SystemWin->FaxSend),MAXSTRING - 1);
   strncpy(info->FaxPrint,fl_get_input(fd_SystemWin->FaxPrint),MAXSTRING - 1);
   strncpy(info->GifCmd    ,fl_get_input(fd_SystemWin->GifCmd ),MAXSTRING - 1);
   strncpy(info->PSCmd     ,fl_get_input(fd_SystemWin->PSCmd ),MAXSTRING - 1);
   strncpy(info->SpoolDir  ,fl_get_input(fd_SystemWin->SpoolDir),MAXSTRING - 1);
   strncpy(info->G3ToXpm    ,fl_get_input(fd_SystemWin->G3ToXpm),MAXSTRING - 1);

   SaveUserInfo(info);
   
   fl_hide_form(fd_SystemWin->SystemWin);
   fl_activate_form(fd_Xfax->Xfax);
}

void SystemCancel(FL_OBJECT *ob, long data)
{
   fl_hide_form(fd_SystemWin->SystemWin);
   fl_activate_form(fd_Xfax->Xfax);
}
