#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "forms.h"
#include "xfaxdefs.h"

typedef struct 
{
   DIR *faxdir;
   int number;
   int maxnumber;
   char *dirname;
   char scratch[MAXSTRING];
} VInfo;

void FaxViewClose(FL_OBJECT *ob, long data)
{
   VInfo * vi = (VInfo *)fd_FaxView->vdata;
   
   closedir(vi->faxdir);
   fl_hide_form(fd_FaxView->FaxView);
   RemoveTmpdir(vi->dirname);
   fl_activate_form(fd_Xfax->Xfax);
}

void SetPageButtons(VInfo *vi)
{
   sprintf(vi->scratch,"%d",vi->number);
   fl_set_object_label(fd_FaxView->PageNumber,vi->scratch);
   
   if(vi->number > 1)
     fl_set_object_lcol(fd_FaxView->FaxViewPrevious,FL_BLACK);
   else
     fl_set_object_lcol(fd_FaxView->FaxViewPrevious,FL_INACTIVE_COL);
     
   if(vi->number < vi->maxnumber)
     fl_set_object_lcol(fd_FaxView->FaxViewNext,FL_BLACK);
   else
     fl_set_object_lcol(fd_FaxView->FaxViewNext,FL_INACTIVE_COL);
}

void FaxViewNext(FL_OBJECT *ob, long parent)
{
   VInfo *vi = (VInfo *)fd_FaxView->vdata;

   if(vi->number >= vi->maxnumber) /* check if there are next pages */
     return;
   
   fl_freeze_form(fd_FaxView->FaxView);

   if(vi->number++ > 0) /* don't free the first time */
;/*      fl_free_bitmap_bitmap(fd_FaxView->FaxBitmap);
*/   SetPageButtons(vi);
   
   sprintf(vi->scratch,"%s/%d.xpm",vi->dirname,vi->number);
   fl_set_bitmap_file(fd_FaxView->FaxBitmap,vi->scratch);
   fl_unfreeze_form(fd_FaxView->FaxView);
}

void FaxViewPrevious(FL_OBJECT *ob, long parent)
{
   VInfo * vi = (VInfo *)fd_FaxView->vdata;

   if(vi->number <= 1) /* check if there are previous pages */
      return;
   
   fl_freeze_form(fd_FaxView->FaxView);
   --vi->number;
/*   fl_free_bitmap_bitmap(fd_FaxView->FaxBitmap);
*/   SetPageButtons(vi);

   sprintf(vi->scratch,"%s/%d.xpm",vi->dirname,vi->number);
   fl_set_bitmap_file(fd_FaxView->FaxBitmap,vi->scratch);
   fl_unfreeze_form(fd_FaxView->FaxView);
}
   
void View(FL_OBJECT *ob, long data)
{
   char cmdbuffer[MAXCMD];
   struct dirent *g3file;
   int km,count,number = 0;
   char *G3ToXpmCmd;
   FL_Coord x,y;
   static VInfo vi; /* MUST be static !!! */
   
   fd_FaxView->vdata = (void *) &vi; /* hook for Info struct */

   fl_get_mouse(&x,&y,&km);
   fl_show_oneliner("Please wait while rendering the \n"
		    "faxpages into XPM format ...",x,y);
   fl_check_forms();

   vi.dirname=tempnam(NULL,"dir");
   
   G3ToXpmCmd = (strlen(info->G3ToXpm) == 0) ? G3TOXPM : info->G3ToXpm;

   mkdir(vi.dirname,0755);
   BuildFaxPages(fd_Xfax,vi.dirname);
   BuildFrontPage(fd_Xfax,vi.dirname);

   fl_check_forms(); /* only to redraw screen if necessary */

   /* Now convert all pages into pixmap format */
   
   strncpy(vi.scratch,vi.dirname,MAXSTRING / 2);
   strcat(vi.scratch,"/");
   strncat(vi.scratch,FRONTPAGE ".001",MAXSTRING / 2 -1);
   if((fclose(fopen(vi.scratch,"r"))) == 0) /* check if file exists */
   { 
      sprintf(cmdbuffer,"%s %s %s/%d.xpm",G3ToXpmCmd,vi.scratch,vi.dirname,++number);
      SpawnCmd(cmdbuffer,1);
   }
   
   vi.faxdir = opendir(vi.dirname);
   count =0;
   while((g3file = readdir(vi.faxdir)) != NULL)
   {
      if(count++ <2) continue;
      if(strncmp(g3file->d_name,G3FAXPAGE,strlen(G3FAXPAGE))) continue;
      
      strncpy(vi.scratch,vi.dirname,MAXSTRING / 2);
      strcat(vi.scratch,"/");
      strncat(vi.scratch,g3file->d_name,MAXSTRING / 2 -1);
      sprintf(cmdbuffer,"%s %s %s/%d.xpm",G3ToXpmCmd,vi.scratch,
	      vi.dirname,++number);
      
      if(number <= 3)
	SpawnCmd(cmdbuffer,1);
      else 
      {
	 SpawnCmd(cmdbuffer,0);	/* run rest in the background : faster !!!! */
	 sleep(2); /* take care not to overload the system ... */
      }
   }
   
   fl_hide_oneliner();
   if(number == 0)
   {
      fl_show_message("","No pages to view !","");
      closedir(vi.faxdir);
      RemoveTmpdir(vi.dirname);
      return;
   }
   
   vi.maxnumber = number;
   vi.number = 0;
   
   sprintf(vi.scratch,"%d",vi.maxnumber);
   fl_set_object_label(fd_FaxView->PageCount,vi.scratch);

   fl_deactivate_form(fd_Xfax->Xfax);
   fl_show_form(fd_FaxView->FaxView,
		FL_PLACE_MOUSE|FL_FREE_SIZE,FL_FULLBORDER,"FaxView");
   
   fl_call_object_callback(fd_FaxView->FaxViewNext); /* show first page */
}

/*
void View(FL_OBJECT *ob, long data)
{
   char cmdbuffer[MAXCMD];
   char filename[MAXSTRING];
   char *dirname = tempnam(NULL,"dir");
   struct dirent *g3file;
   DIR *faxdir;
   int count = 0;
   char *ViewCmd;
   
   ViewCmd = (strlen(info->ViewG3) == 0) ? VIEWG3 : info->ViewG3;
   
   mkdir(dirname,0755);
   BuildFaxPages(fd_Xfax,dirname);
   BuildFrontPage(fd_Xfax,dirname);
   
   strncpy(filename,dirname,MAXSTRING / 2);
   strcat(filename,"/");
   strncat(filename,FRONTPAGE ".001",MAXSTRING / 2 -1);
   if((fclose(fopen(filename,"r"))) == 0)
   { 
      sprintf(cmdbuffer,"%s %s",ViewCmd,filename);
      SpawnCmd(cmdbuffer,1);
   }
   
   faxdir = opendir(dirname);
   while((g3file = readdir(faxdir)) != NULL)
   {
      if(count++ <2) continue;
      if(strncmp(g3file->d_name,G3FAXPAGE,strlen(G3FAXPAGE))) continue;
      
      strncpy(filename,dirname,MAXSTRING / 2);
      strcat(filename,"/");
      strncat(filename,g3file->d_name,MAXSTRING / 2 -1);
      sprintf(cmdbuffer,"%s %s",ViewCmd,filename);
      SpawnCmd(cmdbuffer,1);
   }
   closedir(faxdir);

   RemoveTmpdir(dirname);
}
*/
