
#include "xfax.h"

/* #define FORMS081  TRUE */   /* don't use extensions from 0.84 or higher */

#define MAXLINE      120
#define MAXSTRING    250

#ifdef  FORMS081
#define MAXMESSAGE   500
#define MAXMSGLINES    6   /* Max number of lines in the message part */
#else
#define MAXMESSAGE  1500
#define MAXMSGLINES   20   /* Max number of lines in the message part */
#endif

#define MAXCMD      4000

#define FAXBASE   "/opt/lib/xfax/"

#define HR 1
#define MR 2
#define LR 3
#define VIEWERSIZE HR /*  set the default viewersize to either HR,MR or LR */

/* some presets to use if there is no system or user resource file : */
#define SPOOLDIR  "/tmp"
#define FAXHEADER FAXBASE"faxheader"

#define FAXSEND   FAXBASE"faxsend"
#define FAXPRINT  FAXBASE"faxprint"

#define G3TOXPM   FAXBASE"g3toxbm"

#define GIFTOG3   FAXBASE"giftog3 %s.001 %s"
#define PSTOG3    "gs -q -sDEVICE=faxg3 -dNOPAUSE -sOutputFile=%s.%%03d %s quit.ps"

#ifdef __hpux
/* HPUX efix08 produces bad pgm files no matter if compiled with gcc or 
 the native compiler, so for this reason we have to use efix07 instead, 
 which has a different scaling behaviour.
*/
# define ASCIITOG3 FAXBASE"efix -ve -itext -ofax -p21x29.7cm -d0.3,0.3 -l56 -s2.5x2.5 -n %s.%%03d %s"
# define EDITOR    "nedit"
#else
# define ASCIITOG3 FAXBASE"efix -ve -itext -ofax -p21x29.7cm -d0,0.2 -l62 -n %s.%%03d %s"
# define EDITOR    "xterm -e vi"
#endif

#define XFAXRESOURCES  "xfaxrc"
#define XFAXALIASES    "xfaxaliases"

#define FRONTPAGE      "frontpage.g3"
#define G3FAXPAGE      "g3fax_"
#define FAXINFO        "faxinfo"

/* Next typedef MUST be identical to the definition of the FaxView struct,
 * which can be either HR, MR or LR !!!!!! Check with xfax.h to be sure !!
 */

typedef struct {
   FL_FORM *FaxView;
   void *vdata;
   void *cdata;
   long ldata;
   FL_OBJECT *FaxBitmap;
   FL_OBJECT *FaxViewPrevious;
   FL_OBJECT *FaxViewNext;
   FL_OBJECT *FaxViewClose;
   FL_OBJECT *PageNumber;
   FL_OBJECT *PageCount;
} FD_FaxView;

typedef struct 
{
   char Name[MAXSTRING];
   char Title[MAXSTRING];
   char Department[MAXSTRING];
   char Email[MAXSTRING];
   char Header[MAXSTRING];
   char AsciiCmd[MAXSTRING];
   char PSCmd[MAXSTRING];
   char GifCmd[MAXSTRING];
   char SpoolDir[MAXSTRING];
   char G3ToXpm[MAXSTRING];
   char FaxSend[MAXSTRING];
   char FaxPrint[MAXSTRING];
   char FrontPageFlag[MAXSTRING];
   char EmailFlag[MAXSTRING];
   char Editor[MAXSTRING];
} Xfaxrc;

extern FD_Xfax *fd_Xfax;
extern FD_FromWin *fd_FromWin;
extern FD_SystemWin *fd_SystemWin;
extern FD_LogView *fd_LogView;
extern FD_FaxView *fd_FaxView;
extern FD_Aliases *fd_Aliases;
extern Xfaxrc *info;

/* External function declarations */

char   *BuildResourceFile();
char   *ReadString(const char *label,char *string,FILE *rcfile);
void   InitFromWin(FD_FromWin *fd_FromWin);
void   InitSystemWin(FD_SystemWin *fd_SystemWin);
Xfaxrc *LoadUserInfo();
void   SaveUserInfo(const Xfaxrc *info);
void   RedirectIO(FILE *iohandle);
void   BuildFaxPages(FD_Xfax *fd_Xfax,char *outputdir);
char   *BuildFrontPage(FD_Xfax *fd_Xfax,char *outputdir);
void   SpawnCmd(char *cmdbuffer,int flag);
void   RemoveTmpdir(char *dirname);
int CheckForExistence(char *filename);
