#include <stdio.h>
#include <stdlib.h>

#include "forms.h"

#include "xfaxdefs.h"
#include "twilogo.xpm"

FD_Xfax *fd_Xfax;
FD_FromWin *fd_FromWin;
FD_SystemWin *fd_SystemWin;
FD_LogView *fd_LogView;
FD_FaxView *fd_FaxView;
FD_Aliases *fd_Aliases;
Xfaxrc *info;

void SetFileMenu(FL_OBJECT *ob)
{
   fl_set_menu(ob," Set From info | Set Headerfile | Load message |"
	       " Save message | Exit ");
}

void SetOptionsMenu(FL_OBJECT *ob)
{
   fl_set_menu(ob," Send email | Show Frontpage | System Parameters");

   if(strstr(info->EmailFlag,"True") == NULL)
     fl_set_menu_item_mode(ob,1,FL_PUP_BOX);
   else
     fl_set_menu_item_mode(ob,1,FL_PUP_CHECK);

   if(strstr(info->FrontPageFlag,"True") == NULL)
     fl_set_menu_item_mode(ob,2,FL_PUP_BOX);
   else
     fl_set_menu_item_mode(ob,2,FL_PUP_CHECK);
}

int MessageFilter(FL_OBJECT *ob,const char *old,const char *cur,int c)
{
   int nlcounter;
   const char *ptr = old;

   if(c == '\n')
   {
      nlcounter = 1;
      while(*ptr != 0)
	if(*ptr++ == '\n') nlcounter++;
      if(nlcounter >= MAXMSGLINES)
	return FL_INVALID|FL_RINGBELL;
      /* refuse to avoid cursor runs out of the window */
   }
   return FL_VALID;
}

void Usage(char *naam)
{
   fprintf(stderr,"\nUsage  : %s [options]\n",naam);
   fprintf(stderr,  "Options -v <size> : set viewersize (1=HR,2=MR,3=LR)\n");
   fprintf(stderr,  "\n");
   exit(1);
}

int Initialize(int argc, char *argv[])
{  
   int viewsize = VIEWERSIZE; /* preset an acceptable default */
   char *basename;
   int x;

   basename=argv[0];
   
   x=argc;
   while(--x>0)                    /* parse options */
   {
      if(*argv[1]=='-')
      {
	 switch(*(++argv[1]))
	 {
	  case 'v':
	    if (argc > 2)
	    {
	       viewsize =atoi(argv[2]);
	       ++argv; --argc; --x;
	       break;
	    }
	  default:  Usage(basename); break;
	 }
	 ++argv; --argc;
      }
   }
   
   fl_set_goodies_font(FL_NORMAL_TEXT,14); /* a little bigger ! */
   fl_setpup_fontsize(14);
   fl_set_pixmap_data(fd_Xfax->Logo,twilogo);
   fl_deactivate_object(fd_Xfax->FrontPage); /* only indicator */

   info = LoadUserInfo();

   SetFileMenu(fd_Xfax->FileMenu);
   SetOptionsMenu(fd_Xfax->OptionsMenu);
   
   if(strstr(info->FrontPageFlag,"True") == NULL)
     fl_set_button(fd_Xfax->FrontPage,0);
   else
     fl_set_button(fd_Xfax->FrontPage,1);
   
   RedirectIO(stderr);
   RedirectIO(stdout);

#ifndef FORMS081
   fl_set_input_hscrollbar(fd_Xfax->Message,FL_AUTO);
   fl_set_input_vscrollbar(fd_Xfax->Message,FL_ON);
#endif
   fl_set_input_maxchars(fd_Xfax->Message,MAXMESSAGE -1);
   fl_set_input_filter(fd_Xfax->Message,MessageFilter);  

   return viewsize;
}

int main(int argc, char *argv[])
{
   int viewsize;
     
   fl_initialize(&argc, argv, 0, 0, 0);

   fd_Xfax = create_form_Xfax();
   fd_FromWin = create_form_FromWin();
   fd_SystemWin = create_form_SystemWin();
   fd_LogView = create_form_LogView();
   fd_Aliases = create_form_Aliases();

   viewsize = Initialize(argc,argv);
   
   switch(viewsize)
   {
    case HR : fd_FaxView = (FD_FaxView *) create_form_FaxViewHR(); break;
    case MR : fd_FaxView = (FD_FaxView *) create_form_FaxViewMR(); break;
    case LR : fd_FaxView = (FD_FaxView *) create_form_FaxViewLR(); break;
   }
   
   /* show the first form */
   fl_show_form(fd_Xfax->Xfax,FL_PLACE_CENTER,FL_FULLBORDER,"Xfax");
   while(1)
     fl_do_forms();
   return 0;
}
