#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <Xc/Xc.h>
#include <Xc/Lcd.h>
#include <Xc/BarGraf.h>
#include <Xc/SimpleB.h>
#include <Xc/Led.h>
#include "xzm.h"
#include "taikuk0.xbm"
#include "taikuk1.xbm"
#include "taikuk2.xbm"
#include "taikuk3.xbm"

Widget FTitle, TTitle, FBytesRec, TBytesRec, FBytesExp, TBytesExp;
Widget Thru, FBar, TBar, Message, FTmel, TTmel, TTLeft, FTLeft;
Widget Corea;
int	TaikukFlag;
Pixmap	taikuk[4];

void update(clientData, id)
	 XtPointer clientData;
	 XtIntervalId *id;
{
  XcVType new_value;
  ipcom pipedata;
  char buf[40];
  static char msg[MSGARR];
  
  read(panelpipe[0], (char *)&pipedata, sizeof(pipedata));

  if(pipedata.DispFlag & 2 ) {	/*   */
	/*  ȭ KB  */
	new_value.lval = pipedata.SentFileKB;
	XcLcdUpdateValue(FBytesRec, &new_value);
	new_value.lval = pipedata.SentTotalKB;
	XcLcdUpdateValue(TBytesRec, &new_value);

	new_value.lval = pipedata.Thruput;
	XcLcdUpdateValue(Thru, &new_value);

	new_value.lval = pipedata.FilePercent;
	XcBGUpdateValue(FBar, &new_value);
	new_value.lval = pipedata.TotalPercent;
	XcBGUpdateValue(TBar, &new_value);

	formatTime(buf, pipedata.FileTimeElapsed);
	XcLedSetState(FTmel, NULL, buf);
	formatTime(buf, pipedata.TotalTimeElapsed);
	XcLedSetState(TTmel, NULL, buf);
	formatTime(buf, pipedata.FileTimeLeft);
	XcLedSetState(FTLeft, NULL, buf);
	formatTime(buf, pipedata.TotalTimeLeft);
	XcLedSetState(TTLeft, NULL, buf);
  
	if(pipedata.DispFlag & 1) {	/* ο ȭ  */
#ifdef CHATTER
	  fprintf(stderr, "+++new file\n");
#endif
	  XcLedSetState(FTitle, NULL, pipedata.FileName);
	  sprintf(buf, "%d", pipedata.FilesLeft);
	  XcLedSetState(TTitle, NULL, buf);

	  sprintf(buf, "%d KB", pipedata.FileBytes);
	  XcLedSetState(FBytesExp, NULL, buf);
	  sprintf(buf, "%d KB", pipedata.TotalLeft);
	  XcLedSetState(TBytesExp, NULL, buf);
	}
	XtVaSetValues ( Corea, XtNbitmap, taikuk[TaikukFlag], NULL );
	TaikukFlag = ++TaikukFlag % 4;
  }
  
  if(strncmp(msg, pipedata.Message, MSGLEN)) {
#ifdef CHATTER
	fprintf(stderr, "+++%s\n", msg);
#endif
	strcpy(msg, pipedata.Message);
	XcLedSetState(Message, NULL, pipedata.Message);
  }
}

void quit()
{
  exit(2);
}

Xsz_panel(argc, argv)
	 int argc;
	 char **argv;
{
  Widget TopLevel, MainBox;
  Widget Quit, About;
  XtAppContext app;
  Display *disp;
  Window root;

  TopLevel = XtAppInitialize(&app, "XSz", NULL, 0, &argc, argv, NULL, NULL, 0);
  /* Manager Widget */
  MainBox = XtCreateManagedWidget("mainbox",formWidgetClass, TopLevel,NULL, 0);
  FTitle = XtCreateManagedWidget("fileTitle",xcLedButtonWidgetClass,MainBox,NULL,0);
  TTitle = XtCreateManagedWidget("totalTitle",xcLedButtonWidgetClass,MainBox,NULL, 0);
  Thru = XtCreateManagedWidget("thruput", xcLcdWidgetClass,MainBox, NULL, 0);

  Corea = XtCreateManagedWidget("Taikuk", commandWidgetClass,MainBox, NULL, 0);

  FBytesExp = XtCreateManagedWidget("fileBytes",xcLedButtonWidgetClass,	MainBox, NULL, 0);
  FBytesRec = XtCreateManagedWidget("fileBytesSent",xcLcdWidgetClass,MainBox, NULL, 0);
  FBar = XtCreateManagedWidget("fileBar", xcBarGraphWidgetClass, MainBox,NULL, 0);
  FTmel = XtCreateManagedWidget("fileTimeElapsed",xcLedButtonWidgetClass,MainBox, NULL, 0);
  FTLeft = XtCreateManagedWidget("fileTimeLeft",xcLedButtonWidgetClass,MainBox,NULL,0);

  TBytesExp = XtCreateManagedWidget("totalBytes",xcLedButtonWidgetClass,MainBox, NULL, 0);
  TBytesRec = XtCreateManagedWidget("totalBytesSent", xcLcdWidgetClass,MainBox, NULL, 0);
  TBar = XtCreateManagedWidget("totalBar", xcBarGraphWidgetClass, MainBox,NULL, 0);
  TTmel = XtCreateManagedWidget("totalTimeElapsed",xcLedButtonWidgetClass,MainBox, NULL, 0);
  TTLeft = XtCreateManagedWidget("totalTimeLeft",xcLedButtonWidgetClass,MainBox, NULL, 0);
  Message = XtCreateManagedWidget("message", xcLedButtonWidgetClass,MainBox, NULL, 0);
/*  Quit = XtCreateManagedWidget("quit", xcSimpleButtonWidgetClass,MainBox, NULL, 0); */
  About = XtCreateManagedWidget("about", xcLedButtonWidgetClass,MainBox, NULL,0);

  /* ߿ κ ٷ ̴ */
  XtAppAddInput(app, panelpipe[0], (XtPointer) XtInputReadMask,update, NULL);
  XtAddCallback(Corea, XtNcallback, quit, NULL);

  TaikukFlag = 3;
  disp = XtDisplay( MainBox ); root = DefaultRootWindow( disp );
  taikuk[0] = XCreateBitmapFromData( disp, root, taikuk0_bits, taikuk0_width, taikuk0_height );
  taikuk[1] = XCreateBitmapFromData( disp, root, taikuk1_bits, taikuk1_width, taikuk1_height );
  taikuk[2] = XCreateBitmapFromData( disp, root, taikuk2_bits, taikuk2_width, taikuk2_height );
  taikuk[3] = XCreateBitmapFromData( disp, root, taikuk3_bits, taikuk3_width, taikuk3_height );

  XtRealizeWidget(TopLevel);
  XtAppMainLoop(app);
}
