/*
 *  Flasher Source File
 *
 *  GNU Copyright (C) 2003 Gaspar Sinai <gsinai@yudit.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef memory_model_h
#define memory_model_h

#include "tidbits.h"

namespace FLASHER
{
  /*!
   * \class Page
   * \brief this contains a continuous area.
   */
  class Page
  {
  public:
    Page (unsigned long page_size);
    ~Page();
    void            set (unsigned long at, unsigned char vle);
    unsigned char   get (unsigned long at, unsigned char unset_vle=0xff) const;
    bool            isSet (unsigned long at) const;
  protected:
    unsigned long   m_size;
    BitMap          m_bitmap;
    unsigned char*  m_data;
  };

  /*!
   * \class MemoryModel
   * \brief Simulate the memory.
   */
  class MemoryModel
  {
  public:
    MemoryModel (unsigned long size);
    ~MemoryModel();

    void            set (unsigned long at, unsigned char vle);
    unsigned char   get (unsigned long at, unsigned char unset_vle=0xff) const;
    bool            isSet (unsigned long at) const;
    void            write (const char* fileName, const char* format);
    void            read (const char* fileName, const char* format);
  private:
    Page**          m_pages;
    unsigned long   m_size;
  };
}

#endif /* memory_model_h */
