/*
 *  Flasher Source File
 *
 *  GNU Copyright (C) 2003 Gaspar Sinai <gsinai@yudit.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef flasher_serial_h
#define flasher_serial_h

#include "exception.h"
#include "simple_stream.h"

namespace FLASHER
{
  class Serial
  {
  public:

    /*!
     * \enum BaudRate
     */
    enum BaudRate
    {
        BPS_9600=9600, //!<   9600bps
       BPS_19200=19200, //!<  19200bps
       BPS_38400=38400, //!<  38400bps
       BPS_57600=57600, //!<  57600bps
      BPS_115200=115200  //!< 115200bps
    };

    Serial (const char* port=0);
    ~Serial();

    bool setBaudRate (BaudRate baud);
    BaudRate getBaudRate () const;

    unsigned char read (unsigned int timeout=1000);
    void write  (unsigned char byte);

    void consume (unsigned int timeout=20);
    void wait    (unsigned int ms=20);
    const char*  getName() const; 

  protected:
    BaudRate	 m_baud;
    int          m_fd;
    StringStream m_port;
  };
}

#endif/* flasher_serial_h */
