#!/bin/bash

PRG=./flasher
BAUD=9600
#BAUD=19200
#BAUD=38400
#BAUD=57600
OUT=example.txt
ID=00:00:00:00:00:00:00

function usage()
{
  echo "A simple example script to demonstrate flasher."
  echo "$0 read"
  echo "$0 boot"
  echo "$0 exec"
  exit 1
}

if [ $# =  0 ]
then
   usage 
fi

COMMAND=$1
shift

case "$COMMAND" in
version)
  ./flasher --version
  ;;
read)
  echo "Reading flash memory."
  ./flasher --command read-flash --out $OUT --baud $BAUD --id $ID $*
  ;;
boot)
  echo "Reading boot area."
  ./flasher --command read-boot --out $OUT --baud $BAUD --id $ID $*
  ;;
exec)
  echo "Executing a program in RAM that blinks p00."
  ./flasher --command execute-ram --out $OUT --baud $BAUD --id $ID <<+
\$A00000400,
04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 
7E 9F 51 00 B7 04 00 B7 05 00 7E 8F 51 00 7E 9F
50 00 C7 08 06 00 C7 20 07 00 7E 8F 50 00 EB 30
00 00 EB 40 00 2C 7A EF 80 03 7A FF 00 05 C4 FF
03 E2 03 C4 FE 03 E0 03 F5 07 00 76 10 01 FE F6
B7 00 04 B7 01 04 C7 0A 02 04 AF 00 04 6E FC AF
01 04 6E F7 AF 02 04 6E F2 F3 04 04 04 04 04 04
04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 
FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
+
  ;;
esac
