/*
 *  Flasher Source File
 *
 *  GNU Copyright (C) 2003 Gaspar Sinai <gsinai@yudit.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "tidbits.h"
#include "exception.h"

#include <string.h>

namespace FLASHER
{

  /*!
   * \brief Create a new BitMap.
   * \param size is the size of the BitMap.
   */
  BitMap::BitMap (unsigned long size)
  {
    unsigned long array_size = (size+8-1)/8;
    m_data = new unsigned char[array_size];
    if (m_data==0)
    {
      THROW("Not Enough Memory");
    }
    m_size = size;
    memset (m_data, 0, array_size * sizeof (unsigned char));
  }

  /*!
   * \brief Destroy this BitMap.
   */
  BitMap::~BitMap()
  {
    delete [] m_data;
  }

  /*!
   * \brief Set a bit in the BitMap.
   */
  void
  BitMap::set (unsigned long at, bool vle=true)
  {
    if (at >= m_size) THROW ("Array Out of Bounds[" << m_size << "] at=" << at);
     m_data[at/8] &= ~(1 << (at%8));
     m_data[at/8] |= (vle << (at%8));
  }

  /*!
   * \brief Get a bit from the BitMap.
   * \param at is the location
   * \return true if the bit is set.
   */
  bool
  BitMap::get (unsigned long at) const
  {
    if (at >= m_size) THROW ("Array Out of Bounds[" << m_size << "] at=" << at);
    return (((m_data[at/8] >> (at%8)) & 1) != 0);
  }
}
