/*
 *  Flasher Source File
 *
 *  GNU Copyright (C) 2003 Gaspar Sinai <gsinai@yudit.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef tidbiits_h
#define tidbiits_h


namespace FLASHER
{
  /*!
   * \struct Bit pattern
   */ 
  typedef struct
  {
    unsigned char bit0:1;
    unsigned char bit1:1;
    unsigned char bit2:1;
    unsigned char bit3:1;
    unsigned char bit4:1;
    unsigned char bit5:1;
    unsigned char bit6:1;
    unsigned char bit7:1;
  } Bits;

  /*!
   * \union Byte 
   * \brief the bit pattern of a character.
   */
  typedef union 
  {
    unsigned char byte;       //!< Character representation
    Bits	  bits;      //!< Bit representation
  } Byte;

  /*!
  * \class BitMap
  * \brief A bitmap of arbitrary size. 
  */
  class BitMap
  {
  public:
    BitMap (unsigned long size);
    ~BitMap();
    void set (unsigned long at, bool vle=true);
    bool get (unsigned long at) const;
  protected:
    unsigned long  m_size;
    unsigned char* m_data;
  }; 
}

#endif/* tidbiits_h */
