/*
 * @(#)$Id: client.c,v 1.4 1998/04/04 19:04:51 twitham Rel $
 *
 * Copyright (C) 1998 Tim Witham <twitham@pcocd2.intel.com>
 *
 * (see the files README and COPYING for more details)
 *
 * This file opens and closes client connections to a wx200d server.
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "wx200.h"

#define BUFLEN 32		/* max length of hostname:port */

char wx200host[BUFLEN];
int wx200port = PORT;

/* connect to a wx200d server, return the socket or -1 if error */
int
wx200open(char *hostport)
{
  char *c;
  int s;
  struct sockaddr_in server;
  struct in_addr address;
  struct hostent *host;

  if (hostport != NULL && *hostport != '\0' && *hostport != ':')
    strncpy(wx200host, hostport, BUFLEN);
  else if ((c = getenv("WX200D")) != NULL && *c != '\0' && *c != ':')
    strncpy(wx200host, c, BUFLEN);
  else
    strncpy(wx200host, HOST, BUFLEN);
  if ((c = strchr(wx200host, ':')) != NULL)
    *c = '\0';
  if (hostport != NULL && (c = strrchr(hostport, ':')) != NULL)
    wx200port = strtol(++c, NULL, 0);
  else if ((c = getenv("WX200D")) != NULL && (c = strrchr(c, ':')) != NULL)
    wx200port = strtol(++c, NULL, 0);
  else
    wx200port = PORT;

  if (strspn(wx200host, "0123456789.") == strlen(wx200host)) {
    inet_aton(wx200host, &address);
  } else {
    if ((host = gethostbyname(wx200host)) == NULL) {
      sprintf(error, "%s: can't resolve %s", progname, wx200host);
      herror(error);
      return(-1);
    }
    address.s_addr = ((struct in_addr *)(host->h_addr_list[0]))->s_addr;
/*     fprintf(stderr, "%s=%s=%s\n", wx200host, */
/* 	    host->h_name, inet_ntoa(address)); */
  }
  server.sin_addr=address;
  server.sin_port=htons(wx200port);
  server.sin_family=AF_INET;

  if ((s = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP)) == -1) {
    sprintf(error, "%s: socket", progname);
    perror(error);
    return(-1);
  }
  if (connect(s, (struct sockaddr *)&server,
	      sizeof(struct sockaddr_in)) == -1) {
    sprintf(error, "%s: connect %s:%d", progname, wx200host, wx200port);
    perror(error);
    return(-1);
  }
  return(s);
}

/* close the given wx200 socket connection  */
int
wx200close(int socket)
{
  shutdown(socket, 2);
  return(close(socket));
}
