/*
 * @(#)$Id: format.c,v 1.7 1998/04/01 05:32:47 twitham Rel $
 *
 * Copyright (C) 1998 Tim Witham <twitham@pcocd2.intel.com>
 *
 * (see the files README and COPYING for more details)
 *
 * This file implements unit labels and text formatting.
 *
 */

#include <stdio.h>
#include <string.h>
#include "wx200.h"

UNIT humid_unit[] = {{2, 0, "%", "Percent"}};

UNIT temp_unit[] = {{5, 1, "C", "Degrees Celsius"},
		    {5, 1, "F", "Degrees Fahrenheit"}};

UNIT temp1_unit[] = {{4, 0, "C", "Degrees Celsius"},
		     {4, 0, "F", "Degrees Fahrenheit"},
		     {4, 0, "F", "Degrees Fahrenheit"}};

UNIT press_unit[] = {{5, 2, "in ", "Inches of Mercury"},
		     {5, 1, "mm ", "Millimeters of Mercury"},
		     {5, 0, "mb ", "Millibars"},
		     {5, 0, "hpa", "Hecto-Pascals"}};

UNIT depth_unit[] = {{5, 0, "mm", "Millimeters"},
		     {5, 2, "in", "Inches"}};

UNIT rate_unit[] = {{5, 0, "mm/h", "Millimeters per Hour"},
		    {5, 2, "in/h", "Inches per Hour"}};

UNIT speed_unit[] = {{5, 1, "mph  ", "Miles per Hour"},
		     {5, 1, "knots", "Knots"},
		     {5, 1, "m/s  ", "Meters per Second"},
		     {5, 1, "kph  ", "Kilometers per Hour"}};

char *wind_unit4[] = {"N", "E", "S", "W",};
char *wind_unit8[] = {"N ", "NE", "E ", "SE", "S ", "SW", "W ", "NW"};
char *wind_unit16[] = {" N ", "NNE", "NE ", "ENE", " E ", "ESE", "SE ", "SSE",
		       " S ", "SSW", "SW ", "WSW", " W ", "WNW", "NW ", "NNW"};

char
unit_flag(int err, int or)
{
  char flag_unit[] = " *!#";
  return(flag_unit[((err ? 1 : 0) << 1) | (or ? 1 : 0)]);
}

void
unit_format(char *buf, SENS *sensormem, int format,
	    UNIT *unit, float (*convert)(float, int))
{
  int p, w;
  float n;
  char numbuf[10];

  w = unit[format].w;
  p = unit[format].p;
  n = convert(sensormem->n, format);
  do {				/* drop decimals if too wide */
    sprintf(numbuf, "%*.*f", w, p--, n);
  } while (p >= 0 && strlen(numbuf) > w);
  sprintf(buf, "%s%c%s", numbuf,
	  unit_flag(sensormem->err, sensormem->or), unit[format].l);
}

char *
_format_data(int val, int what, char *buf, SENS *sensormem, int format)
{

  switch (what) {
  case F_HUMID:
    unit_format(buf, sensormem, format, humid_unit, &unit_humid);
    break;
  case F_TEMP:
    unit_format(buf, sensormem, format, temp_unit, &unit_temp);
    break;
  case F_TEMP1:
    unit_format(buf, sensormem, format, temp1_unit, &unit_temp);
    break;
  case F_DIFF1:
    unit_format(buf, sensormem, format ? 2 : 0, temp1_unit, &unit_temp);
    break;
  case F_PRESS:
    unit_format(buf, sensormem, format, press_unit, &unit_press);
    break;
  case F_DEPTH:
    unit_format(buf, sensormem, format, depth_unit, &unit_depth);
    break;
  case F_RATE:
    unit_format(buf, sensormem, format, rate_unit, &unit_depth);
    break;
  case F_SPEED:
    unit_format(buf, sensormem, format, speed_unit, &unit_speed);
    break;
  case F_DIR:
    sprintf(buf, "%03d%s", sensormem->val,
	    wind_unit16[unit_dir(sensormem->n, 16)]);
    break;
  case F_TIME:
    sprintf(buf, "%2d/%2d %2d:%02d%s",
	    format & 0x02 ? sensormem->mon : sensormem->day,
	    format & 0x02 ? sensormem->day : sensormem->mon,
	    format & 0x01 ? sensormem->hour
	    : (sensormem->hour % 12 ? sensormem->hour % 12 : 12),
	    sensormem->min,
	    format & 0x01 ? "  " : (sensormem->hour >= 12 ? "pm" : "am"));
    break;
  }
  return(buf);
}

char *
format_data(int what, char *buf, SENS *sensormem, int format)
{
  _format_data(0, what, buf, sensormem, format);
  return(buf);
}

char *
format_val(int what, char *buf, float val, int format)
{
  SENS t;

  t.err = t.or = 0;
  t.n = val;
  t.val = val;
  _format_data(1, what, buf, &t, format);
  return(buf);
}
