# -*- shell-script -*-
#
# @(#)$Id: gnuplot.cmd,v 1.1 1998/01/31 22:16:20 twitham Rel $
#
# Copyright (C) 1998 Tim Witham <twitham@pcocd2.intel.com>
#
# (see the files README and COPYING for more details)
#
# This file implements a gnuplot weather data plotter!

# The tab-delimited ASCII format is currently:

#  1 hour.fractionofhour
#  2 indoor temperature C
#  3 outdoor temperature C
#  4 indoor humidity %
#  5 outdoor humidity %
#  6 indoor dew point C
#  7 outdoor dew point C
#  8 local barometric pressure mb
#  9 sea barometric pressure mb
# 10 wind gust direction degrees
# 11 wind gust speed m/s
# 12 wind avg. direction degrees
# 13 wind avg. speed m/s
# 14 rainfall rate mm/hr

set grid
# set time
# set data style lines
# set data style dots
set format x "%g:00"
set xtics 0,3
set xlabel "WX200"

set title "Temperature"
set format y "%g C"
set ylabel "Degrees Celsius"
plot "dat.tab" using 1:2 title 'Indoor', "dat.tab" using 1:3 title 'Outdoor'
pause -1 "Hit return to continue"

set title "Relative Humidity"
set format y "%g %"
set ylabel "Percent"
plot "dat.tab" using 1:4 title 'Indoor', "dat.tab" using 1:5 title 'Outdoor'
pause -1 "Hit return to continue"

set title "Dew Point"
set format y "%g C"
set ylabel "Degrees Celsius"
plot "dat.tab" using 1:6 title 'Indoor', "dat.tab" using 1:7 title 'Outdoor'
pause -1 "Hit return to continue"

set title "Barometric Pressure"
set format y "%g mb"
set ylabel "Millibars"
plot "dat.tab" using 1:8 title 'Local', "dat.tab" using 1:9 title 'Sea Level'
pause -1 "Hit return to continue"

set title "Wind Direction"
set format y "%g"
set ylabel "Direction"
set ytics ("N" 0, "NE" 45, "E" 90, "SE" 135, "S" 180, "SW" 225, "W" 270, "NW" 315)
plot "dat.tab" using 1:10 title 'Gust', "dat.tab" using 1:12 title 'Average'
pause -1 "Hit return to continue"

set title "Wind Speed"
set format y "%g m/s"
set ylabel "Meters per Second"
set ytics
plot "dat.tab" using 1:11 title 'Gust', "dat.tab" using 1:13 title 'Average'
pause -1 "Hit return to continue"

set title "Wind Chill"
set format y "%g C"
set ylabel "Degrees Celsius"
plot "dat.tab" using 1:14 title 'Wind Chill'
pause -1 "Hit return to continue"

set title "Rain Fall Rate"
set format y "%g mm/hr"
set ylabel "Millimeters per Hour"
plot "dat.tab" using 1:15 title 'Rain Rate'
pause -1 "Hit return to continue"
