/*
 * @(#)$Id: parse.c,v 1.10 1998/09/06 03:32:24 twitham Rel $
 *
 * Copyright (C) 1998 Tim Witham <twitham@pcocd2.intel.com>
 *
 * (see the files README and COPYING for more details)
 *
 * This file parses the data from groupbuf into memory structures.
 *
 */

#include <unistd.h>
#include "wx200.h"

Time td;
Humid humid;
Temp temp;
Baro baro;
Dew dew;
Rain rain;
Wind wind;
Chill chill;
Gen gen;
Unk unk;

/* parse groupbuf[bufnum] into memory structures, returning # bytes parsed */
int
wx200parse(int bufnum)
{
  int ret;
  unsigned char *buf;

  ret = 0;
  buf = groupbuf[bufnum];
  switch (bufnum) {
  case GROUPF:			/* Time */
  case GROUP8:			/* Time, Humidity */
    td.clock.sec = NUM(buf[1]);
    td.clock.min = NUM(buf[2]);
    td.clock.hour = NUM(buf[3]);
    ret = 3;
    if (bufnum == GROUPF)
      break;
    td.clock.day = NUM(buf[4]);
    td.format = (buf[5] & 0x30) >> 4;
    td.clock.mon = LO(buf[5]);
    unk.eightf5 = buf[5] & 0xc0;
    td.a.nlo = td.a.lo = NUM(buf[6]);
    td.a.nhi = td.a.hi = NUM(buf[7]);
    ERROR(humid.in, buf[8], NUM(buf[8]));
    humid.in.n = humid.in.val;
    humid.inhi.n = humid.inhi.val = NUM(buf[9]);
    humid.inhi.min = NUM(buf[10]);
    humid.inhi.hour = NUM(buf[11]);
    humid.inhi.day = NUM(buf[12]);
    humid.inhi.mon = LO(buf[13]);
    humid.inlo.n = humid.inlo.val = 10 * LO(buf[14]) + HI(buf[13]);
    humid.inlo.min = 10 * LO(buf[15]) + HI(buf[14]);
    humid.inlo.hour = 10 * LO(buf[16]) + HI(buf[15]);
    humid.inlo.day = 10 * LO(buf[17]) + HI(buf[16]);
    humid.inlo.mon = HI(buf[17]);
    humid.ina.nhi = humid.ina.hi = NUM(buf[18]);
    humid.ina.nlo = humid.ina.lo = NUM(buf[19]);
    ERROR(humid.out, buf[20], NUM(buf[20]));
    humid.out.n = humid.out.val;
    humid.outhi.n = humid.outhi.val = NUM(buf[21]);
    humid.outhi.min = NUM(buf[22]);
    humid.outhi.hour = NUM(buf[23]);
    humid.outhi.day = NUM(buf[24]);
    humid.outhi.mon = LO(buf[25]);
    humid.outlo.n = humid.outlo.val = 10 * LO(buf[26]) + HI(buf[25]);
    humid.outlo.min = 10 * LO(buf[27]) + HI(buf[26]);
    humid.outlo.hour = 10 * LO(buf[28]) + HI(buf[27]);
    humid.outlo.day = 10 * LO(buf[29]) + HI(buf[28]);
    humid.outlo.mon = HI(buf[29]);
    humid.outa.nhi = humid.outa.hi = NUM(buf[30]);
    humid.outa.nlo = humid.outa.lo = NUM(buf[31]);
    humid.outhi.or = BIT(buf[32], 3);
    humid.out.or = BIT(buf[32], 4);
    humid.inhi.or = BIT(buf[32], 6);
    humid.in.or = BIT(buf[32], 7);
    unk.eightf32 = buf[32] & 0x27;
    unk.eightf33 = buf[33] & 0x07;
    td.a.on = BIT(buf[33], 3);
    humid.ina.on = buf[33] & 0xc0 ? 1 : 0;
    humid.outa.on = buf[33] & 0x30 ? 1 : 0;
    ret = 33;
    break;
  case GROUP9:			/* Temperature */
    ERROR(temp.in, buf[1], (buf[2] & 0x08 ? -1 : 1)
	  * (100 * (buf[2] & 0x07) + NUM(buf[1])));
    temp.in.n = TENTHS(temp.in.val);
    temp.inhi.val = (buf[3] & 0x80 ? -1 : 1)
      * (10 * NUM(buf[3] & 0x7f) + HI(buf[2]));
    temp.inhi.n = TENTHS(temp.inhi.val);
    temp.inhi.min = NUM(buf[4]);
    temp.inhi.hour = NUM(buf[5]);
    temp.inhi.day = NUM(buf[6]);
    temp.inhi.mon = LO(buf[7]);
    temp.inlo.val = (buf[8] & 0x80 ? -1 : 1)
      * (10 * NUM(buf[8] & 0x7f) + HI(buf[7]));
    temp.inlo.n = TENTHS(temp.inlo.val);
    temp.inlo.min = NUM(buf[9]);
    temp.inlo.hour = NUM(buf[10]);
    temp.inlo.day = NUM(buf[11]);
    temp.inlo.mon = LO(buf[12]);
    unk.ninef13 = buf[13] & 0xe0;
    temp.ina.hi = 10 * NUM(buf[13]) + HI(buf[12]);
    temp.ina.nhi = F2C(temp.ina.hi);
    temp.ina.lo = 100 * BIT(buf[15], 0) + NUM(buf[14]);
    temp.ina.nlo = F2C(temp.ina.lo);
    temp.format = BIT(buf[15], 6);
    unk.ninef15 = buf[15] & 0xbe;
    ERROR(temp.out, buf[16], (buf[17] & 0x08 ? -1 : 1)
	  * (100 * (buf[17] & 0x07) + NUM(buf[16])));
    temp.out.n = TENTHS(temp.out.val);
    temp.outhi.val = (buf[18] & 0x80 ? -1 : 1)
      * (10 * NUM(buf[18] & 0x7f) + HI(buf[17]));
    temp.outhi.n = TENTHS(temp.outhi.val);
    temp.outhi.min = NUM(buf[19]);
    temp.outhi.hour = NUM(buf[20]);
    temp.outhi.day = NUM(buf[21]);
    temp.outhi.mon = LO(buf[22]);
    temp.outlo.val = (buf[23] & 0x80 ? -1 : 1)
      * (10 * NUM(buf[23] & 0x7f) + HI(buf[22]));
    temp.outlo.n = TENTHS(temp.outlo.val);
    temp.outlo.min = NUM(buf[24]);
    temp.outlo.hour = NUM(buf[25]);
    temp.outlo.day = NUM(buf[26]);
    temp.outlo.mon = LO(buf[27]);
    unk.ninef28 = buf[28] & 0x60;
    temp.outa.hi = (buf[28] & 0x80 ? -1 : 1)
      * (10 * NUM(buf[28] & 0x1f) + HI(buf[27]));
    temp.outa.nhi = F2C(temp.outa.hi);
    temp.outa.lo = (buf[30] & 0x08 ? -1 : 1)
      * (100 * BIT(buf[30], 0) + NUM(buf[29]));
    temp.outa.nlo = F2C(temp.outa.lo);
    unk.ninef30 = buf[30] & 0xf6;
    unk.ninef31 = buf[31];
    temp.ina.on = buf[33] & 0xc0 ? 1 : 0;
    temp.outa.on = buf[33] & 0x30 ? 1 : 0;
    temp.ina.on = buf[32] & 0xc0 ? 1 : 0;
    temp.outa.on = buf[32] & 0x30 ? 1 : 0;
    ret = 32;
    break;
  case GROUPA:			/* Barometer, Dew Point */
    ERROR(baro.local, buf[2], 1000 * NUM(buf[2]) + 10 * NUM(buf[1]));
    baro.local.n = TENTHS(baro.local.val);
    ERROR(baro.sea, buf[5],
	  10000 * LO(buf[5]) + 100 * NUM(buf[4]) + NUM(buf[3]));
    baro.sea.n = TENTHS(baro.sea.val);
    baro.format = HI(buf[5] & 0x30);
    unk.af5 = buf[5] & 0xc0;
    baro.pred = LO(buf[6]);
    baro.trend = HI(buf[6] & 0x70);
    unk.af6 = buf[6] & 0x80;

    ERROR(dew.in, buf[7], NUM(buf[7]));
    dew.in.n = dew.in.val;
    dew.inhi.n = dew.inhi.val = NUM(buf[8]);
    dew.inhi.min = NUM(buf[9]);
    dew.inhi.hour = NUM(buf[10]);
    dew.inhi.day = NUM(buf[11]);
    dew.inhi.mon = LO(buf[12]);
    dew.inlo.n = dew.inlo.val = 10 * LO(buf[13]) + HI(buf[12]);
    dew.inlo.min = 10 * LO(buf[14]) + HI(buf[13]);
    dew.inlo.hour = 10 * LO(buf[15]) + HI(buf[14]);
    dew.inlo.day = 10 * LO(buf[16]) + HI(buf[15]);
    dew.inlo.mon = HI(buf[16]);
    dew.ina.nlo = dew.ina.lo = LO(buf[17]) + 1;
    dew.outa.nlo = dew.outa.nlo = HI(buf[17]) + 1;
    ERROR(dew.out, buf[18], NUM(buf[18]));
    dew.out.n = dew.out.val;
    dew.outhi.n = dew.outhi.val = NUM(buf[19]);
    dew.outhi.min = NUM(buf[20]);
    dew.outhi.hour = NUM(buf[21]);
    dew.outhi.day = NUM(buf[22]);
    dew.outhi.mon = LO(buf[23]);
    dew.outlo.n = dew.outlo.val = 10 * LO(buf[24]) + HI(buf[23]);
    dew.outlo.min = 10 * LO(buf[25]) + HI(buf[24]);
    dew.outlo.hour = 10 * LO(buf[26]) + HI(buf[25]);
    dew.outlo.day = 10 * LO(buf[27]) + HI(buf[26]);
    dew.outlo.mon = HI(buf[27]);
    dew.outlo.or = BIT(buf[28], 0);
    dew.out.or = BIT(buf[28], 2);
    unk.af28 = buf[28] & 0xfa;
    dew.ina.on = dew.outa.on = buf[29] & 0x60 ? 1 : 0;
    baro.a.on = BIT(buf[29], 7);
    baro.a.nhi = baro.a.hi = LO(buf[29]) + 1;
    unk.af29 = buf[29] & 0x10;
    ret = 29;
    break;
  case GROUPB:			/* Rain */
    ERROR(rain.rate, buf[1], 100 * LO(buf[2]) + NUM(buf[1]));
    rain.rate.n = rain.rate.val;
    unk.bf2 = buf[2] & 0xf0;
    rain.yest.n = rain.yest.val = 100 * NUM(buf[4]) + NUM(buf[3]);
    rain.total.n = rain.total.val = 100 * NUM(buf[6]) + NUM(buf[5]);
    rain.total.min = NUM(buf[7]);
    rain.total.hour = NUM(buf[8]);
    rain.total.day = NUM(buf[9]);
    rain.total.mon = LO(buf[10]);
    unk.bf10 = buf[10] & 0xd0;
    rain.format = BIT(buf[10], 5);
    rain.a.hi = 100 * LO(buf[12]) + NUM(buf[11]);
    rain.a.nhi = IN2MM(TENTHS(rain.a.hi));
    rain.a.on = BIT(buf[12], 4);
    rain.rate.or = BIT(buf[12], 7);
    unk.bf12 = buf[12] & 0x60;
    ret = 12;
    break;
  case GROUPC:			/* Wind, Wind Chill, General */
    ERROR(wind.gspeed, buf[1], 100 * LO(buf[2]) + NUM(buf[1]));
    wind.gspeed.n = TENTHS(wind.gspeed.val);
    wind.gdir.n = wind.gdir.val = 10 * NUM(buf[3]) + HI(buf[2]);
    ERROR(wind.aspeed, buf[4], 100 * LO(buf[5]) + NUM(buf[4]));
    wind.aspeed.n = TENTHS(wind.aspeed.val);
    wind.adir.n = wind.adir.val = 10 * NUM(buf[6]) + HI(buf[5]);
    wind.speedhi.val = 100 * LO(buf[8]) + NUM(buf[7]);
    wind.speedhi.n = TENTHS(wind.speedhi.val);
    wind.dirhi.n = wind.dirhi.val = 10 * NUM(buf[9]) + HI(buf[8]);
    wind.speedhi.min = NUM(buf[10]);
    wind.speedhi.hour = NUM(buf[11]);
    wind.speedhi.day = NUM(buf[12]);
    wind.speedhi.mon = LO(buf[13]);
    wind.a.hi = (buf[14] & 0x10 ? 100 : 0) + 10 * LO(buf[14]) + HI(buf[13]);
    wind.a.nhi = MPH2MPS(wind.a.hi);
    unk.cf14 = buf[14] & 0xe0;
    unk.cf15 = buf[15] & 0x3f;
    wind.format = (buf[15] & 0xc0) >> 6;
    ERROR(chill.temp, buf[16], (buf[21] & 0x20 ? -1 : 1) * NUM(buf[16]));
    chill.temp.n = chill.temp.val;
    chill.low.n = chill.low.val = (buf[21] & 0x10 ? -1 : 1) * NUM(buf[17]);
    chill.low.min = NUM(buf[18]);
    chill.low.hour = NUM(buf[19]);
    chill.low.day = NUM(buf[20]);
    chill.low.mon = LO(buf[21]);
    unk.cf21 = buf[21] & 0xc0;
    chill.a.lo = (buf[23] & 0x08 ? -1 : 1)
      * (100 * HI(buf[23] & 0x10) + NUM(buf[22]));
    chill.a.nlo = F2C(chill.a.lo);
    unk.cf23 = buf[23] & 0x27;
    gen.power = BIT(buf[23], 6);
    gen.lowbat = BIT(buf[23], 7);
    gen.section = HI(buf[24] & 0x70);
    gen.screen = (buf[24] & 0x0c) >> 2;
    gen.subscreen = buf[24] & 0x03;
    unk.cf24 = buf[24] & 0x80;
    chill.a.on = BIT(buf[25], 1);
    wind.a.on = BIT(buf[25], 2);
    wind.speedhi.or = BIT(buf[25], 5);
    wind.aspeed.or = BIT(buf[25], 6);
    wind.gspeed.or = BIT(buf[25], 7);
    unk.cf25 = buf[25] & 0x19;
    ret = 25;
  break;
  }
  return(ret);
}
