/*
 * @(#)$Id: serial.c,v 1.3 1998/02/07 06:14:14 twitham Rel $
 *
 * Copyright (C) 1998 Tim Witham <twitham@pcocd2.intel.com>
 *
 * (see the files README and COPYING for more details)
 *
 * This file implements the unix (Linux) serial interface to WX200.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <termio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include "wx200.h"

int speed=B9600, bits=CS8, stopbits=0, parity=0;

char *device = NULL;		/* serial device name */
struct termio stbuf, svbuf;	/* termios: svbuf=saved, stbuf=set */

/* serial cleanup routine called as the program exits */
void
cleanup_serial(int fd)
{
  if (fd > 0) {
    if (ioctl(fd, TCSETA, &svbuf) < 0) {
      sprintf(error, "%s: can't ioctl set device %s", progname, device);
      perror(error);
    }
    close(fd);
  }
}

/* return file descriptor of successfully opened serial device or negative # */
int
init_serial(char *dev)
{
  int fd=-1;			/* serial device file descriptor */

  if (dev != NULL)
    device = dev;
  else if ((device = getenv("WX200")) == NULL) /* default to env var */
    device = WX200;		/* or built-in default */
  if ((fd = open(device, O_RDONLY)) < 0) {
    sprintf(error, "%s: can't open device %s", progname, device);
    perror(error);
    return(-1);
  }
  if (ioctl(fd, TCGETA, &svbuf) < 0) {
    sprintf(error, "%s: can't ioctl get device %s", progname, device);
    perror(error);
    close(fd);
    return(-2);
  }
  memcpy(&stbuf, &svbuf, sizeof(struct termio));
  stbuf.c_iflag = 0;
  stbuf.c_oflag = 0;
  stbuf.c_lflag = 0;
  stbuf.c_cflag = speed | bits | stopbits | parity | CLOCAL | CREAD;
  if (ioctl(fd, TCSETA, &stbuf) < 0) {
    sprintf(error, "%s: can't ioctl set device %s", progname, device);
    perror(error);
    close(fd);
    return(-3);
  }
  return(fd);
}
