/*
 * @(#)$Id: tab.c,v 1.2 1998/01/31 03:43:38 twitham Rel $
 *
 * Copyright (C) 1998 Tim Witham <twitham@pcocd2.intel.com>
 *
 * (see the files README and COPYING for more details)
 *
 * This file parses the data from groupbuf into tab-delimited ASCII tabbuf.
 *
 */

#include <stdio.h>
#include <string.h>
#include "wx200.h"

char tabbuf[TABLEN];

int _tabchanged = 0;
int _tablast = -1;
char _tabprev[TABLEN];

void
wx200tabinit() {
  _tabchanged = 0;
  _tablast = -1;
  _tabprev[0] = '\0';
}

/* call wx200parse(group), returning whether tabbuf changed */
int
wx200tab(int group) {
  static int ret;
  static char buf[TABLEN];
  static float time = 0;

  ret = 0;
  if (group >= 0) {		/* GROUPC,F,8 indicate end of previous record */
    if (group == GROUPC || group == GROUPF || group == GROUP8) {
      if (group == GROUPC) {
	_tabchanged = 1;	/* handle a GROUPC change now */
	wx200parse(group);
	if (_tablast == GROUPC) time += 5.0 / 3600.0; /* add 5 seconds? */
      }
      if (_tabchanged) {	/* did something change in previous record? */
	sprintf(buf,
		"%g\t%g\t%g\t%g\t%g\t%g\t%g\t%g\t%g\t%g\t%g\t%g\t%g\t%g",
		temp.in.n, temp.out.n,
		humid.in.n, humid.out.n,
		dew.in.n, dew.out.n,
		baro.local.n, baro.sea.n,
		wind.gdir.n, wind.gspeed.n,
		wind.adir.n, wind.aspeed.n,
		chill.temp.n, rain.rate.n);
	if (strncmp(_tabprev, buf, TABLEN)) { /* a change we care about? */
	  sprintf(tabbuf, "%.4f\t%s\n", time, buf); /* yes, export it */
	  ret = 1;
	  strncpy(_tabprev, buf, TABLEN); /* for comparison next time */
	}
      }
      _tabchanged = group == GROUP8 ? 1 : 0; /* C handled, F don't care */
    } else {			/* GROUP9,A,B changed */
      _tabchanged = 1;
    }
    if (group != GROUPC) {	/* C handled and printed already */
      wx200parse(group);	/* update data and clock */
      time = td.clock.hour + td.clock.min / 60.0 + td.clock.sec / 3600.0;
    }
    _tablast = group;
  }
  return(ret);
}
