/*
 * @(#)$Id: wxdebug.c,v 1.10 1998/09/06 03:34:52 twitham Rel $
 *
 * Copyright (C) 1998 Tim Witham <twitham@pcocd2.intel.com>
 *
 * (see the files README and COPYING for more details)
 *
 * This file implements a debuging filter (stdin to stdout).
 *
 */

#include <stdio.h>
#include <unistd.h>
#include "wx200.h"

#define ALARM(flag)	(flag ? 'A' : 'a')
#define OR(flag)	(flag ? 'O' : 'o')
#define ERR(flag)	(flag ? 'E' : 'e')

void
showhex(unsigned char *buf, int num)
{
  int i;
  for (i = 0; i < num; i++) {
    printf("%s%02x", (i % 2 ? " " : ""), buf[i]);
  }
  printf("\n");
}

int
main(int argc, char **argv)
{
  const char *flags = "Hh0189abcfupx";
  int opt, group, eight, nine, a, b, c, f, u, p = 1, x = -1;
  Unk prev;

  eight = nine = a = b = c = f = u = 1;
  while ((opt = getopt(argc, argv, flags)) != EOF) {
    switch (opt) {
    case '?':
    case 'h':
    case 'H':
      printf("usage: debug [-0189abcfupx]\n"
	     "\t0\tall groups off\n\t1\tall groups on (default)\n"
	     "\tpx\ttoggle plain mode (default on) and hex mode (default off)\n"
	     "\t89abcfu\ttoggle group on/off, f=timestamp, u=unknowns\n");
      exit(0);
    case '0':
      eight = nine = a = b = c = f = u = -1;
      break;
    case '1':
      eight = nine = a = b = c = f = u = 1;
      break;
    case '8':
      eight *= -1;
      break;
    case '9':
      nine *= -1;
      break;
    case 'a':
      a *= -1;
      break;
    case 'b':
      b *= -1;
      break;
    case 'c':
      c *= -1;
      break;
    case 'f':
      f *= -1;
      break;
    case 'u':
      u *= -1;
      break;
    case 'p':
      p *= -1;
      break;
    case 'x':
      x *= -1;
      break;
    }
  }
  wx200bufinit();
  while ((group = wx200bufread(0)) != EOF) {
    if (group >= 0)
      wx200parse(group);
    switch (group) {
    case GROUPF:
      if (f < 0) break;
      if (x > 0) showhex(groupbuf[group], grouplen[group]);
      if (p > 0)
	printf("f %02d:%02d:%02d\n",
	       td.clock.hour, td.clock.min, td.clock.sec);
      break;
    case GROUP8:
      if (eight < 0) break;
      if (x > 0) showhex(groupbuf[group], grouplen[group]);
      if (p > 0)
	printf("8 %02d/%02d:%02d:%02d:%02d %c%02d:%02d"
	       " %c%d-%d=%d%c%02d/%02d:%02d:%02d<%c%d%c<%d%c%02d/%02d:%02d:%02d"
	       " %c%d-%d=%d%c%02d/%02d:%02d:%02d<%c%d%c<%d%c%02d/%02d:%02d:%02d"
	       " f%d\n",

	       td.clock.mon, td.clock.day, td.clock.hour, td.clock.min,
	       td.clock.sec, ALARM(td.a.on), td.a.hi, td.a.lo,

	       ALARM(humid.ina.on), humid.ina.lo, humid.ina.hi,
	       humid.inlo.val, OR(humid.inlo.or),
	       humid.inlo.mon, humid.inlo.day,
	       humid.inlo.hour, humid.inlo.min,
	       ERR(humid.in.err), humid.in.val, OR(humid.in.or),
	       humid.inhi.val, OR(humid.inhi.or),
	       humid.inhi.mon, humid.inhi.day,
	       humid.inhi.hour, humid.inhi.min,

	       ALARM(humid.outa.on), humid.outa.lo, humid.outa.hi,
	       humid.outlo.val, OR(humid.outlo.or),
	       humid.outlo.mon, humid.outlo.day,
	       humid.outlo.hour, humid.outlo.min,
	       ERR(humid.out.err), humid.out.val, OR(humid.out.or),
	       humid.outhi.val, OR(humid.outhi.or),
	       humid.outhi.mon, humid.outhi.day,
	       humid.outhi.hour, humid.outhi.min,

	       td.format);
      break;
    case GROUP9:
      if (nine < 0) break;
      if (x > 0) showhex(groupbuf[group], grouplen[group]);
      if (p > 0)
	printf("9"
	       " %c%d-%d=%d%c%02d/%02d:%02d:%02d<%c%d%c<%d%c%02d/%02d:%02d:%02d"
	       " %c%d-%d=%d%c%02d/%02d:%02d:%02d<%c%d%c<%d%c%02d/%02d:%02d:%02d"
	       " f%d\n",


	       ALARM(temp.ina.on), temp.ina.lo, temp.ina.hi,
	       temp.inlo.val, OR(temp.inlo.or),
	       temp.inlo.mon, temp.inlo.day,
	       temp.inlo.hour, temp.inlo.min,
	       ERR(temp.in.err), temp.in.val, OR(temp.in.or),
	       temp.inhi.val, OR(temp.inhi.or),
	       temp.inhi.mon, temp.inhi.day,
	       temp.inhi.hour, temp.inhi.min,

	       ALARM(temp.outa.on), temp.outa.lo, temp.outa.hi,
	       temp.outlo.val, OR(temp.outlo.or),
	       temp.outlo.mon, temp.outlo.day,
	       temp.outlo.hour, temp.outlo.min,
	       ERR(temp.out.err), temp.out.val, OR(temp.out.or),
	       temp.outhi.val, OR(temp.outhi.or),
	       temp.outhi.mon, temp.outhi.day,
	       temp.outhi.hour, temp.outhi.min,

	       temp.format);
      break;
    case GROUPA:
      if (a < 0) break;
      if (x > 0) showhex(groupbuf[group], grouplen[group]);
      if (p > 0)
	printf("a"
	       " %c%d=%d%c%02d/%02d:%02d:%02d<%c%d%c<%d%c%02d/%02d:%02d:%02d"
	       " %c%d=%d%c%02d/%02d:%02d:%02d<%c%d%c<%d%c%02d/%02d:%02d:%02d"
	       " l%c%d%c s%c%d%c p%dt%df%d\n",

	       ALARM(dew.ina.on), dew.ina.lo,
	       dew.inlo.val, OR(dew.inlo.or),
	       dew.inlo.mon, dew.inlo.day,
	       dew.inlo.hour, dew.inlo.min,
	       ERR(dew.in.err), dew.in.val, OR(dew.in.or),
	       dew.inhi.val, OR(dew.inhi.or),
	       dew.inhi.mon, dew.inhi.day,
	       dew.inhi.hour, dew.inhi.min,

	       ALARM(dew.outa.on), dew.outa.lo,
	       dew.outlo.val, OR(dew.outlo.or),
	       dew.outlo.mon, dew.outlo.day,
	       dew.outlo.hour, dew.outlo.min,
	       ERR(dew.out.err), dew.out.val, OR(dew.out.or),
	       dew.outhi.val, OR(dew.outhi.or),
	       dew.outhi.mon, dew.outhi.day,
	       dew.outhi.hour, dew.outhi.min,

	       ERR(baro.local.err), baro.local.val, OR(baro.local.or),
	       ERR(baro.sea.err), baro.sea.val, OR(baro.sea.or),

	       baro.pred, baro.trend, baro.format);
      break;
    case GROUPB:
      if (b < 0) break;
      if (x > 0) showhex(groupbuf[group], grouplen[group]);
      if (p > 0)
	printf("b %c%d r%c%d%c y%d%c t%d%c %02d/%02d:%02d:%02d f%d\n",
	       ALARM(rain.a.on), rain.a.hi,
	       ERR(rain.rate.err), rain.rate.val, OR(rain.rate.or),
	       rain.yest.val, OR(rain.yest.or),
	       rain.total.val, OR(rain.total.or),
	       rain.total.mon, rain.total.day, rain.total.hour, rain.total.min,
	       rain.format);
      break;
    case GROUPC:
      if (c < 0 && u < 0) break;
      if (c > 0 && x > 0) showhex(groupbuf[group], grouplen[group]);
      if (c > 0 && p > 0)
	printf("c %c%d"
	       " g%c%03d@%c%d%c~%c%03d@%c%d%c<%03d@%d%c=%02d/%02d:%02d:%02d"
	       " %c%d %d%c%02d/%02d:%02d:%02d<%c%d%c"
	       " p%d b%d s%d/%d/%d f%d\n",

	       ALARM(wind.a.on), wind.a.hi,

	       ERR(wind.gdir.err), wind.gdir.val,
	       ERR(wind.gspeed.err), wind.gspeed.val, OR(wind.gspeed.or),
	       ERR(wind.adir.err), wind.adir.val,
	       ERR(wind.aspeed.err), wind.aspeed.val, OR(wind.aspeed.or),
	       wind.dirhi.val, wind.speedhi.val, OR(wind.speedhi.or),
	       wind.speedhi.mon, wind.speedhi.day,
	       wind.speedhi.hour, wind.speedhi.min,

	       ALARM(chill.a.on), chill.a.lo,
	       chill.low.val, OR(chill.low.or),
	       chill.low.mon, chill.low.day, chill.low.hour, chill.low.min,
	       ERR(chill.temp.err), chill.temp.val, OR(chill.temp.or),

	       gen.power, gen.lowbat, gen.section, gen.screen, gen.subscreen,
	       wind.format);
      if (u > 0 && p > 0) {
	if (memcmp(&unk, &prev, sizeof(unk)))
	  printf("u 5=%x,32=%x,33=%x/13=%x,15=%x,28=%x,30=%x,31=%x"
		 "/5=%x,6=%x,28=%x,29=%x/2=%x,10=%x,12=%x"
		 "/14=%x,15=%x,21=%x,23=%x,24=%x,25=%x\n",
		 unk.eightf5, unk.eightf32, unk.eightf33, unk.ninef13,
		 unk.ninef15, unk.ninef28, unk.ninef30, unk.ninef31,
		 unk.af5, unk.af6, unk.af28, unk.af29,
		 unk.bf2, unk.bf10, unk.bf12,
		 unk.cf14, unk.cf15, unk.cf21, unk.cf23, unk.cf24, unk.cf25);
	memcpy(&prev, &unk, sizeof(unk));
      }
      break;
    }
  }
  exit(0);
}
