/*
 * @(#)$Id: wxread.c,v 1.3 1998/02/07 06:14:34 twitham Rel $
 *
 * Copyright (C) 1998 Tim Witham <twitham@pcocd2.intel.com>
 *
 * (see the files README and COPYING for more details)
 *
 * This file reads the serial port directly and sends it to stdout.
 *
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include "wx200.h"

char *progname;
char error[80];

/* main program */
int
main(int argc, char **argv)
{
  int c, fd;
  char *device = NULL;

  progname = strrchr(argv[0], '/');
  if (progname == NULL)
    progname = argv[0];
  else
    progname++;
  if (argc > 1)
    if (argv[1] != NULL)
      device = argv[1];
  if ((fd = init_serial(device)) < 0)
    exit(fd);
  while (read(fd, &c, 1) == 1) {
    putchar(c);
    fflush(stdout);
  }
  cleanup_serial(fd);
  exit(0);
}
