#include <termios.h>

struct mdm_dialogo
	{
	char *escribe;
	int   plazo;
	char *espera;
	};

extern int mdm_verboso;
extern int mdm_modem;			/* el fd del modem */

#define MDM_VEL_19200	B19200
#define MDM_VEL_38400	B38400
#define MDM_VEL_57600	B57600
#define MDM_VEL_115200	B115200
#define MDM_VEL_230400	B230400

#define MDM_ERR_OK			0
#define MDM_ERR_BLOQUEADO	1
#define MDM_ERR_FICH_LOCK	2
#define MDM_ERR_FICH_DEV	3
#define MDM_ERR_SET		2
#define MDM_ERR_RESET		5
#define MDM_ERR_SELECT		6
#define MDM_ERR_TIMEOUT		7



/**********************************/
/* APERTURA Y CIERRE DE mdm_modem */
/**********************************/

int mdm_inicia(char *dev, int vel_puerto);
int mdm_termina(void);

/**********************************/
/* ESCRITURA Y LECTURA BAJO NIVEL */
/**********************************/

void mdm_escribe( char *cad );
void mdm_escribebyte( char car );

int mdm_lee( int plazo, char *buf );
int mdm_leebyte( int plazo, char *byte );

/***********/
/* DIALOGO */
/***********/

int mdm_espera( int plazo, char *buf, char *cad );
int mdm_escribe_espera( char *escribe, int plazo, char *buf, char *espera );
int mdm_dialoga( struct mdm_dialogo dlg[], char *buf );

/************/	
/* FICHEROS */
/************/

unsigned long mdm_graba(int f, char *dtmfs, int para_si_tecla,
    char *dtmfs_parar);
unsigned long mdm_reproduce(int f, char *dtmfs, int para_si_tecla,
    char *dtmfs_parar);
    
